      REAL*8 FUNCTION POT_NUC(XR,ANCLR)
! THIS FUNCTION RETURNS THE POTENTIAL INSIDE THE NUCLEUS
! ASSUMING A HOMOGENOUSLY CHARGED SPHERE
      REAL*8 XR,ANCLR,RNUC
      RNUC=RNUCTAB(NINT(ANCLR))
      POT_NUC=(ANCLR/RNUC**3)*(XR**2-3*RNUC**2)
      END FUNCTION              ! OF POT_NUC




      REAL*8 FUNCTION RNUCTAB(Z)
! THIS FUNCTION CONTAINS THE NUCLEAR RADII FOR MANY Z CALCULATED
! 1.128*A**(1/3)FM (HERE SAVED IN A.U.)
      REAL*8 RNUC
      INTEGER Z
      DIMENSION RNUC(109)
      DATA RNUC /2.688280D-05,3.394993D-05,3.893984D-05,4.293464D-05,
     &4.632524D-05,4.930297D-05,5.197748D-05,5.441818D-05,5.667210D-05,
     &5.877274D-05,6.074494D-05,6.260766D-05,6.437575D-05,6.606108D-05,
     &6.767330D-05,6.922041D-05,7.070905D-05,7.214488D-05,7.353271D-05,
     &7.487670D-05,7.618046D-05,7.744715D-05,7.867954D-05,7.988009D-05,
     &8.105101D-05,8.219423D-05,8.331154D-05,8.440452D-05,8.547461D-05,
     &8.652311D-05,8.755123D-05,8.856005D-05,8.955057D-05,9.052372D-05,
     &9.148035D-05,9.242124D-05,9.334712D-05,9.425867D-05,9.515651D-05,
     &9.604123D-05,9.691338D-05,9.777347D-05,9.862198D-05,9.945937D-05,
     &1.002860D-04,1.011024D-04,1.019088D-04,1.027057D-04,1.034933D-04,
     &1.042720D-04,1.050420D-04,1.058038D-04,1.065574D-04,1.073032D-04,
     &1.080414D-04,1.087723D-04,1.094961D-04,1.102130D-04,1.109231D-04,
     &1.116267D-04,1.123240D-04,1.130152D-04,1.137003D-04,1.143796D-04,
     &1.150532D-04,1.157213D-04,1.163840D-04,1.170414D-04,1.176938D-04,
     &1.183411D-04,1.189835D-04,1.196212D-04,1.202542D-04,1.208827D-04,
     &1.215068D-04,1.221265D-04,1.227420D-04,1.233534D-04,1.239607D-04,
     &1.245640D-04,1.251634D-04,1.257591D-04,1.263510D-04,1.269393D-04,
     &1.275240D-04,1.281052D-04,1.286830D-04,1.292574D-04,1.298285D-04,
     &1.303964D-04,1.309611D-04,1.315227D-04,1.320813D-04,1.326369D-04,
     &1.331895D-04,1.337392D-04,1.342861D-04,1.348302D-04,1.353715D-04,
     &1.359102D-04,1.364462D-04,1.369796D-04,1.375105D-04,1.380389D-04,
     &1.385648D-04,1.390882D-04,1.396093D-04,1.401280D-04,1.406444D-04/
      RNUCTAB=RNUC(Z)
      END FUNCTION              !OF GET_R






