      FUNCTION WCOREHOLE( Z, NC, LC, IK ) 
C **********************************************************************
C *                                                                    *
C *  Z    integer       atomic number                                  *
C *  NC   integer       principal quantum number of core shell         *
C *  LC   integer       angular momentum quantum  number of core shell * 
C *  IK   integer       select SOC-split subshell                      * 
C *                     1: j=l-1/2  2: j=l+1/2                         *    
C *                                                                    *    
C *  Lorentzian core hole life time (width)    in [eV]                 *
C *                                                                    *
C *  taken from:  unoccupied electronic states                         *
C *               eds.: j.c.fuggle & j.e.inglesfield                   *
C *               topics in applied physics  vol. 69                   *
C *               springer, berlin, 1992                               *
C *               appendix b                                           *
C *                                                                    *
C **********************************************************************
      INTEGER Z
      REAL    WCOREHOLE 
      REAL    WK(104), WL1(104), WL2(104), WL3(104), 
     &        WM1(104), WM2(104), WM3(104), WM4(104), WM5(104), 
     &        WN1(104), WN2(104), WN3(104), WN4(104), WN5(104),
     &        WN6(104), WN7(104), 
     &        WO1(104), WO2(104), WO3(104), WO4(104), WO5(104),
     &        WP1(104), WP2(104), WP3(104)

      SAVE 
      DATA WK /  
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.24, 
     &  0.30, 0.36, 0.42, 0.48, 0.53, 0.59, 0.64, 0.68, 0.74, 0.81, 
     &  0.86, 0.94, 1.01, 1.08, 1.16, 1.25, 1.33, 1.44, 1.55, 1.67, 
     &  1.82, 1.96, 2.14, 2.33, 2.52, 2.75, 2.99, 3.25, 3.52, 3.84, 
     &  4.14, 4.52, 4.91, 5.33, 5.77, 6.24, 6.75, 7.28, 7.91, 8.49, 
     &  9.19, 9.89,10.60,11.40,12.30,13.20,14.10,15.10,16.20,17.30, 
     & 18.50,19.70,21.00,22.30,23.90,25.20,26.80,28.40,30.10,31.90, 
     & 33.70,35.70,37.70,39.90,24.10,44.40,46.80,49.30,52.00,54.60, 
     & 57.40,60.40,63.40,66.60,69.80,73.30,76.80,80.40,84.10,88.00, 
     & 91.90,96.10, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00 /
c
      DATA (WL1(I),I=1,104) /  
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.10, 
     &  0.20, 0.40, 0.70, 1.03, 1.26, 1.49, 1.20, 1.03, 1.40, 1.83, 
     &  2.21, 2.34, 2.41, 2.54, 2.62, 2.76, 2.79, 2.89, 3.06, 3.28, 
     &  2.80, 3.53, 3.79, 3.94, 4.11, 4.28, 4.44, 4.67, 4.71, 4.78, 
     &  4.94, 4.25, 4.36, 4.58, 4.73, 4.93, 4.88, 4.87, 5.00, 2.97, 
     &  3.13, 3.32, 3.46, 3.64, 3.78, 3.92, 4.06, 4.21, 4.34, 4.52, 
     &  4.67, 4.80, 4.91, 5.05, 5.19, 5.25, 5.33, 5.43, 5.47, 5.53, 
     &  5.54, 5.63, 5.58, 5.61, 6.18, 7.25, 8.30, 9.39,10.50,11.30, 
     & 12.00,12.20,12.40,12.60,12.80,13.10,13.30,13.40,13.60,13.70, 
     & 14.30,14.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00 /
c
      DATA (WL2(I),I=1,104) /  
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.02, 0.03, 0.05, 0.08, 0.13, 0.15, 0.17, 
     &  0.19, 0.24, 0.26, 0.29, 0.34, 0.37, 0.43, 0.52, 0.62, 0.72, 
     &  0.83, 0.95, 1.03, 1.13, 1.21, 1.31, 1.43, 1.54, 1.65, 1.78, 
     &  1.87, 1.97, 2.08, 2.23, 2.35, 2.43, 2.57, 2.62, 2.72, 2.84, 
     &  3.00, 3.12, 3.25, 3.40, 3.51, 3.57, 3.68, 3.80, 3.89, 3.97, 
     &  4.06, 4.15, 4.23, 4.32, 4.43, 4.55, 4.66, 4.73, 4.79, 4.82, 
     &  4.92, 5.02, 5.15, 5.33, 5.48, 5.59, 5.69, 5.86, 6.00, 6.17, 
     &  6.32, 6.48, 6.67, 6.83, 7.01, 7.20, 7.47, 7.68, 7.95, 8.18, 
     &  8.75, 9.32, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00 /
c
      DATA (WL3(I),I=1,104) /  
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.02, 0.03, 0.05, 0.09, 0.13, 0.16, 0.17, 
     &  0.19, 0.10, 0.20, 0.20, 0.20, 0.20, 0.30, 0.30, 0.40, 0.66, 
     &  0.76, 0.82, 0.94, 1.00, 1.08, 1.17, 1.27, 1.39, 1.50, 1.57, 
     &  1.66, 1.78, 1.91, 2.00, 2.13, 2.25, 2.40, 2.50, 2.65, 2.75, 
     &  2.87, 2.95, 3.08, 3.13, 3.25, 3.32, 3.41, 3.48, 3.60, 3.65, 
     &  3.75, 3.86, 3.91, 4.01, 4.12, 4.17, 4.26, 4.35, 4.48, 4.60, 
     &  4.68, 4.80, 4.88, 4.98, 5.04, 5.16, 5.25, 5.31, 5.41, 5.50, 
     &  5.65, 5.81, 5.98, 6.13, 6.29, 6.41, 6.65, 6.82, 6.98, 7.13, 
     &  7.33, 7.43, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00 /
c
      DATA (WM1(I),I=1,104) /  
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00 /
c
      DATA (WM2(I),I=1,104) /  
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00 /
c
      DATA (WM3(I),I=1,104) /  
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00 /
c
      DATA (WM4(I),I=1,104) /  
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00 /
c
      DATA (WM5(I),I=1,104) /  
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00 /
c
      DATA (WN1(I),I=1,104) /  
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00 /
c
      DATA (WN2(I),I=1,104)/  
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00 /
c
      DATA (WN3(I),I=1,104) /  
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00 /
c
      DATA (WN4(I),I=1,104) /  
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00 /
c
      DATA (WN5(I),I=1,104) /  
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00 /
c
      DATA (WN6(I),I=1,104) /  
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00 /
c
      DATA (WN7(I),I=1,104) /  
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00 /
c
      DATA (WO1(I),I=1,104) /  
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00 /
c
      DATA (WO2(I),I=1,104) /  
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00 /
c
      DATA (WO3(I),I=1,104) /  
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00 /
c
      DATA (WO4(I),I=1,104) /  
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00 /
c
      DATA (WO5(I),I=1,104) /  
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     &  0.00, 0.00, 0.00, 0.00 /

      IF( Z .LT. 1 .OR. Z .GT. 104 ) GOTO 9999
      WCOREHOLE = 9999.9999
c-----------------------------------------------------------------------
      IF( NC .EQ. 1 ) THEN
         IF( Z .LE. 2 ) GOTO 9999
         WCOREHOLE = WK( Z )
      END IF
c-----------------------------------------------------------------------
      IF( NC .EQ. 2 ) THEN
         IF( Z .LE. 10 ) GOTO 9999
         IF( LC .EQ. 0 ) THEN
            WCOREHOLE = WL1( Z )
         ELSE
            IF( IK .EQ. 1 ) THEN
               WCOREHOLE = WL2( Z )
            ELSE
               WCOREHOLE = WL3( Z )
            END IF
         END IF
      END IF
c-----------------------------------------------------------------------
      IF( NC .EQ. 3 ) THEN
         IF( LC .EQ. 0 ) THEN
            WCOREHOLE = WM1( Z )
         ELSE
            IF( LC .EQ. 1 ) THEN
               IF( IK .EQ. 1 ) THEN
                  WCOREHOLE = WM2( Z )
               ELSE
                  WCOREHOLE = WM3( Z )
               END IF
            ELSE    
               IF( IK .EQ. 1 ) THEN
                  WCOREHOLE = WM4( Z )
               ELSE
                  WCOREHOLE = WM5( Z )
               END IF
            END IF
         END IF
      END IF
c-----------------------------------------------------------------------
      IF( NC .EQ. 4 ) THEN
         IF( LC .EQ. 0 ) THEN
            WCOREHOLE = WN1( Z )
         ELSE
            IF( LC .EQ. 1 ) THEN
               IF( IK .EQ. 1 ) THEN
                  WCOREHOLE = WN2( Z )
               ELSE
                  WCOREHOLE = WN3( Z )
               END IF
            ELSE    
               IF( LC .EQ. 2 ) THEN
                  IF( IK .EQ. 1 ) THEN
                     WCOREHOLE = WN4( Z )
                  ELSE
                     WCOREHOLE = WN5( Z )
                  END IF
               ELSE
                  IF( IK .EQ. 1 ) THEN
                     WCOREHOLE = WN6( Z )
                  ELSE
                     WCOREHOLE = WN7( Z )
                  END IF
               END IF
            END IF
         END IF
      END IF

      IF( WCOREHOLE .GT. 9000.0 ) GOTO 9999
      
      RETURN

c-----------------------------------------------------------------------
 9999 WRITE(*,*) 'trouble in <WCOREHOLE> '
      WRITE(*,*) ' Z  ', Z
      WRITE(*,*) ' NC ', NC
      WRITE(*,*) ' LC ', LC
      WRITE(*,*) ' IK ', IK
      STOP
      END              
