      SUBROUTINE EILANG(ANG,IG)
C      INCLUDE 'PREC.H'
      implicit double precision (a-h,o-z)
      PARAMETER (P=3.141592653589793D0)
      PARAMETER (Z=0.D0,H=P/2,H3=3*H,T=P/3,T2=T*2,T4=T*4,T5=T*5)
      DIMENSION C(3,32),ANG(3)
      DATA C/
     >Z,Z,Z, Z,P,Z, Z,P,P, P,Z,Z, P,H,H, Z,H,H3, P,H,H3, Z,H,H,
     >H,H,Z, H ,H ,P, H3,H,P, H3,H,Z, H3,P,Z, H,Z,Z, H3,Z,Z,
     >H,P,Z, Z,H,P, P,H,Z, Z,H,Z, P,H,P, H3,H,H3, H3,H,H, H,H,H,
     >H,H,H3,
     >T,Z,Z, T2,Z,Z, T4,Z,Z, T5,Z,Z, T4,P,Z, T5,P,Z, T,P,Z, T2,P,Z/
      ANG(1)=C(1,IG)
      ANG(2)=C(2,IG)
      ANG(3)=C(3,IG)
      end
      SUBROUTINE EILNAM(ANG,IG)
      character*5 Z,H,H3,T,T2,T4,T5,P
      PARAMETER (Z='  0',H='Pi/2',H3='3Pi/2',T='Pi/3',T2='2Pi/3',T4
     $     ='4Pi/3',T5='5Pi/3',P='  Pi')
      character*5 C(3,32)
      character *(*) ang
      DATA C/
     >Z,Z,Z, Z,P,Z, Z,P,P, P,Z,Z, P,H,H, Z,H,H3, P,H,H3, Z,H,H,
     >H,H,Z, H ,H ,P, H3,H,P, H3,H,Z, H3,P,Z, H,Z,Z, H3,Z,Z,
     >H,P,Z, Z,H,P, P,H,Z, Z,H,Z, P,H,P, H3,H,H3, H3,H,H, H,H,H,
     >H,H,H3,
     >T,Z,Z, T2,Z,Z, T4,Z,Z, T5,Z,Z, T4,P,Z, T5,P,Z, T,P,Z, T2,P,Z/
      write(ang,1)C(1,IG),C(2,IG),C(3,IG)
 1    format(a,' ;',a,' ;',a)
      END
      SUBROUTINE TURNM(OM,U)
C      INCLUDE 'PREC.H'
      implicit double precision (a-h,o-z)
      DIMENSION U(3,3),OM(3)
      SINA=SIN(OM(1))
      SINB=SIN(OM(2))
      SING=SIN(OM(3))
      COSA=COS(OM(1))
      COSB=COS(OM(2))
      COSG=COS(OM(3))
      U(1,1)=COSA*COSB*COSG-SINA*SING
      U(1,2)=-COSA*COSB*SING-SINA*COSG
      U(1,3)=COSA*SINB
      U(2,1)=SINA*COSB*COSG+COSA*SING
      U(2,2)=-SINA*COSB*SING+COSA*COSG
      U(2,3)=SINA*SINB
      U(3,1)=-SINB*COSG
      U(3,2)=SINB*SING
      U(3,3)=COSB
      END
      subroutine multable(in)
      DIMENSION IN(64,64)
      DIMENSION IND(64,64)
      DATA (IND( 1,i),i=1,64)/
     > 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15,16,17,18,19,20,21,22,
     >23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,
     >45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64/
      DATA (IND( 2,i),i=1,64)/
     > 2, 1, 4, 3, 6, 5, 8, 7,10, 9,12,11,14,13,16,15,18,17,20,19,22,21,
     >24,23,30,29,32,31,26,25,28,27,34,33,36,35,38,37,40,39,42,41,44,43,
     >46,45,48,47,50,49,52,51,54,53,56,55,62,61,64,63,58,57,60,59/
      DATA (IND( 3,i),i=1,64)/
     > 3, 4, 1, 2, 7, 8, 5, 6,11,12, 9,10,15,16,13,14,19,20,17,18,23,24,
     >21,22,32,31,30,29,28,27,26,25,35,36,33,34,39,40,37,38,43,44,41,42,
     >47,48,45,46,51,52,49,50,55,56,53,54,64,63,62,61,60,59,58,57/
      DATA (IND( 4,i),i=1,64)/
     > 4, 3, 2, 1, 8, 7, 6, 5,12,11,10, 9,16,15,14,13,20,19,18,17,24,23,
     >22,21,27,28,25,26,31,32,29,30,36,35,34,33,40,39,38,37,44,43,42,41,
     >48,47,46,45,52,51,50,49,56,55,54,53,59,60,57,58,63,64,61,62/
      DATA (IND( 5,i),i=1,64)/
     > 5, 8, 6, 7, 9,12,10,11, 1, 4, 2, 3,17,20,18,19,21,24,22,23,13,16,
     >14,15, 0, 0, 0, 0, 0, 0, 0, 0,37,40,38,39,41,44,42,43,33,36,34,35,
     >49,52,50,51,53,56,54,55,45,48,46,47, 0, 0, 0, 0, 0, 0, 0, 0/
      DATA (IND( 6,i),i=1,64)/
     > 6, 7, 5, 8,10,11, 9,12, 2, 3, 1, 4,18,19,17,20,22,23,21,24,14,15,
     >13,16, 0, 0, 0, 0, 0, 0, 0, 0,38,39,37,40,42,43,41,44,34,35,33,36,
     >50,51,49,52,54,55,53,56,46,47,45,48, 0, 0, 0, 0, 0, 0, 0, 0/
      DATA (IND( 7,i),i=1,64)/
     > 7, 6, 8, 5,11,10,12, 9, 3, 2, 4, 1,19,18,20,17,23,22,24,21,15,14,
     >16,13, 0, 0, 0, 0, 0, 0, 0, 0,39,38,40,37,43,42,44,41,35,34,36,33,
     >51,50,52,49,55,54,56,53,47,46,48,45, 0, 0, 0, 0, 0, 0, 0, 0/
      DATA (IND( 8,i),i=1,64)/
     > 8, 5, 7, 6,12, 9,11,10, 4, 1, 3, 2,20,17,19,18,24,21,23,22,16,13,
     >15,14, 0, 0, 0, 0, 0, 0, 0, 0,40,37,39,38,44,41,43,42,36,33,35,34,
     >52,49,51,50,56,53,55,54,48,45,47,46, 0, 0, 0, 0, 0, 0, 0, 0/
      DATA (IND( 9,i),i=1,64)/
     > 9,11,12,10, 1, 3, 4, 2, 5, 7, 8, 6,21,23,24,22,13,15,16,14,17,19,
     >20,18, 0, 0, 0, 0, 0, 0, 0, 0,41,43,44,42,33,35,36,34,37,39,40,38,
     >53,55,56,54,45,47,48,46,49,51,52,50, 0, 0, 0, 0, 0, 0, 0, 0/
      DATA (IND( 10,i),i=1,64)/
     >10,12,11, 9, 2, 4, 3, 1, 6, 8, 7, 5,22,24,23,21,14,16,15,13,18,20,
     >19,17, 0, 0, 0, 0, 0, 0, 0, 0,42,44,43,41,34,36,35,33,38,40,39,37,
     >54,56,55,53,46,48,47,45,50,52,51,49, 0, 0, 0, 0, 0, 0, 0, 0/
      DATA (IND( 11,i),i=1,64)/
     >11, 9,10,12, 3, 1, 2, 4, 7, 5, 6, 8,23,21,22,24,15,13,14,16,19,17,
     >18,20, 0, 0, 0, 0, 0, 0, 0, 0,43,41,42,44,35,33,34,36,39,37,38,40,
     >55,53,54,56,47,45,46,48,51,49,50,52, 0, 0, 0, 0, 0, 0, 0, 0/
      DATA (IND( 12,i),i=1,64)/
     >12,10, 9,11, 4, 2, 1, 3, 8, 6, 5, 7,24,22,21,23,16,14,13,15,20,18,
     >17,19, 0, 0, 0, 0, 0, 0, 0, 0,44,42,41,43,36,34,33,35,40,38,37,39,
     >56,54,53,55,48,46,45,47,52,50,49,51, 0, 0, 0, 0, 0, 0, 0, 0/
      DATA (IND( 13,i),i=1,64)/
     >13,15,14,16,21,23,22,24,17,19,18,20, 1, 3, 2, 4, 9,11,10,12, 5, 7,
     > 6, 8, 0, 0, 0, 0, 0, 0, 0, 0,45,47,46,48,53,55,54,56,49,51,50,52,
     >33,35,34,36,41,43,42,44,37,39,38,40, 0, 0, 0, 0, 0, 0, 0, 0/
      DATA (IND( 14,i),i=1,64)/
     >14,16,13,15,22,24,21,23,18,20,17,19, 2, 4, 1, 3,10,12, 9,11, 6, 8,
     > 5, 7, 0, 0, 0, 0, 0, 0, 0, 0,46,48,45,47,54,56,53,55,50,52,49,51,
     >34,36,33,35,42,44,41,43,38,40,37,39, 0, 0, 0, 0, 0, 0, 0, 0/
      DATA (IND( 15,i),i=1,64)/
     >15,13,16,14,23,21,24,22,19,17,20,18, 3, 1, 4, 2,11, 9,12,10, 7, 5,
     > 8, 6, 0, 0, 0, 0, 0, 0, 0, 0,47,45,48,46,55,53,56,54,51,49,52,50,
     >35,33,36,34,43,41,44,42,39,37,40,38, 0, 0, 0, 0, 0, 0, 0, 0/
      DATA (IND( 16,i),i=1,64)/
     >16,14,15,13,24,22,23,21,20,18,19,17, 4, 2, 3, 1,12,10,11, 9, 8, 6,
     > 7, 5, 0, 0, 0, 0, 0, 0, 0, 0,48,46,47,45,56,54,55,53,52,50,51,49,
     >36,34,35,33,44,42,43,41,40,38,39,37, 0, 0, 0, 0, 0, 0, 0, 0/
      DATA (IND( 17,i),i=1,64)/
     >17,18,20,19,13,14,16,15,21,22,24,23, 5, 6, 8, 7, 1, 2, 4, 3, 9,10,
     >12,11, 0, 0, 0, 0, 0, 0, 0, 0,49,50,52,51,45,46,48,47,53,54,56,55,
     >37,38,40,39,33,34,36,35,41,42,44,43, 0, 0, 0, 0, 0, 0, 0, 0/
      DATA (IND(18,i),i=1,64)/
     >18,17,19,20,14,13,15,16,22,21,23,24, 6, 5, 7, 8, 2, 1, 3, 4,10, 9,
     >11,12, 0, 0, 0, 0, 0, 0, 0, 0,50,49,51,52,46,45,47,48,54,53,55,56,
     >38,37,39,40,34,33,35,36,42,41,43,44, 0, 0, 0, 0, 0, 0, 0, 0/
      DATA (IND(19,i),i=1,64)/
     >19,20,18,17,15,16,14,13,23,24,22,21, 7, 8, 6, 5, 3, 4, 2, 1,11,12,
     >10, 9, 0, 0, 0, 0, 0, 0, 0, 0,51,52,50,49,47,48,46,45,55,56,54,53,
     >39,40,38,37,35,36,34,33,43,44,42,41, 0, 0, 0, 0, 0, 0, 0, 0/
      DATA (IND(20,i),i=1,64)/
     >20,19,17,18,16,15,13,14,24,23,21,22, 8, 7, 5, 6, 4, 3, 1, 2,12,11,
     > 9,10, 0, 0, 0, 0, 0, 0, 0, 0,52,51,49,50,48,47,45,46,56,55,53,54,
     >40,39,37,38,36,35,33,34,44,43,41,42, 0, 0, 0, 0, 0, 0, 0, 0/
      DATA (IND(21,i),i=1,64)/
     >21,24,23,22,17,20,19,18,13,16,15,14, 9,12,11,10, 5, 8, 7, 6, 1, 4,
     > 3, 2, 0, 0, 0, 0, 0, 0, 0, 0,53,56,55,54,49,52,51,50,45,48,47,46,
     >41,44,43,42,37,40,39,38,33,36,35,34, 0, 0, 0, 0, 0, 0, 0, 0/
      DATA (IND(22,i),i=1,64)/
     >22,23,24,21,18,19,20,17,14,15,16,13,10,11,12, 9, 6, 7, 8, 5, 2, 3,
     > 4, 1, 0, 0, 0, 0, 0, 0, 0, 0,54,55,56,53,50,51,52,49,46,47,48,45,
     >42,43,44,41,38,39,40,37,34,35,36,33, 0, 0, 0, 0, 0, 0, 0, 0/
      DATA (IND(23,i),i=1,64)/
     >23,22,21,24,19,18,17,20,15,14,13,16,11,10, 9,12, 7, 6, 5, 8, 3, 2,
     > 1, 4, 0, 0, 0, 0, 0, 0, 0, 0,55,54,53,56,51,50,49,52,47,46,45,48,
     >43,42,41,44,39,38,37,40,35,34,33,36, 0, 0, 0, 0, 0, 0, 0, 0/
      DATA (IND(24,i),i=1,64)/
     >24,21,22,23,20,17,18,19,16,13,14,15,12, 9,10,11, 8, 5, 6, 7, 4, 1,
     > 2, 3, 0, 0, 0, 0, 0, 0, 0, 0,56,53,54,55,52,49,50,51,48,45,46,47,
     >44,41,42,43,40,37,38,39,36,33,34,35, 0, 0, 0, 0, 0, 0, 0, 0/
      DATA (IND(25,i),i=1,64)/
     >25,31,29,27, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     > 0, 0,26, 4,28, 1,30, 2,32, 3,57,63,61,59, 0, 0, 0, 0, 0, 0, 0, 0,
     > 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,58,36,60,33,62,34,64,35/
      DATA (IND(26,i),i=1,64)/
     >26,32,30,28, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     > 0, 0, 4,27, 1,25, 2,31, 3,29,58,64,62,60, 0, 0, 0, 0, 0, 0, 0, 0,
     > 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,36,59,33,57,34,63,35,61/
      DATA (IND(27,i),i=1,64)/
     >27,29,31,25, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     > 0, 0,28, 1,26, 4,32, 3,30, 2,59,61,63,57, 0, 0, 0, 0, 0, 0, 0, 0,
     > 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,60,33,58,36,64,35,62,34/
      DATA (IND(28,i),i=1,64)/
     >28,30,32,26, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     > 0, 0, 1,25, 4,27, 3,29, 2,31,60,62,64,58, 0, 0, 0, 0, 0, 0, 0, 0,
     > 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,33,57,36,59,35,61,34,63/
      DATA (IND(29,i),i=1,64)/
     >29,27,25,31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     > 0, 0, 3,32, 2,30, 1,28, 4,26,61,59,57,63, 0, 0, 0, 0, 0, 0, 0, 0,
     > 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,35,64,34,62,33,60,36,58/
      DATA (IND(30,i),i=1,64)/
     >30,28,26,32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     > 0, 0,29, 3,31, 2,25, 1,27, 4,62,60,58,64, 0, 0, 0, 0, 0, 0, 0, 0,
     > 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,61,35,63,34,57,33,59,36/
      DATA (IND(31,i),i=1,64)/
     >31,25,27,29, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     > 0, 0, 2,30, 3,32, 4,26, 1,28,63,57,59,61, 0, 0, 0, 0, 0, 0, 0, 0,
     > 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,34,62,35,64,36,58,33,60/
      DATA (IND(32,i),i=1,64)/
     >32,26,28,30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     > 0, 0,31, 2,29, 3,27, 4,25, 1,64,58,60,62, 0, 0, 0, 0, 0, 0, 0, 0,
     > 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,63,34,61,35,59,36,57,33/
      DATA (IND(33,i),i=1,64)/
     >33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,
     >55,56,57,58,59,60,61,62,63,64, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,
     >13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32/
      DATA (IND(34,i),i=1,64)/
     >34,33,36,35,38,37,40,39,42,41,44,43,46,45,48,47,50,49,52,51,54,53,
     >56,55,62,61,64,63,58,57,60,59, 2, 1, 4, 3, 6, 5, 8, 7,10, 9,12,11,
     >14,13,16,15,18,17,20,19,22,21,24,23,30,29,32,31,26,25,28,27/
      DATA (IND(35,i),i=1,64)/
     >35,36,33,34,39,40,37,38,43,44,41,42,47,48,45,46,51,52,49,50,55,56,
     >53,54,64,63,62,61,60,59,58,57, 3, 4, 1, 2, 7, 8, 5, 6,11,12, 9,10,
     >15,16,13,14,19,20,17,18,23,24,21,22,32,31,30,29,28,27,26,25/
      DATA (IND(36,i),i=1,64)/
     >36,35,34,33,40,39,38,37,44,43,42,41,48,47,46,45,52,51,50,49,56,55,
     >54,53,59,60,57,58,63,64,61,62, 4, 3, 2, 1, 8, 7, 6, 5,12,11,10, 9,
     >16,15,14,13,20,19,18,17,24,23,22,21,27,28,25,26,31,32,29,30/
      DATA (IND(37,i),i=1,64)/
     >37,40,38,39,41,44,42,43,33,36,34,35,49,52,50,51,53,56,54,55,45,48,
     >46,47, 0, 0, 0, 0, 0, 0, 0, 0, 5, 8, 6, 7, 9,12,10,11, 1, 4, 2, 3,
     >17,20,18,19,21,24,22,23,13,16,14,15, 0, 0, 0, 0, 0, 0, 0, 0/
      DATA (IND(38,i),i=1,64)/
     >38,39,37,40,42,43,41,44,34,35,33,36,50,51,49,52,54,55,53,56,46,47,
     >45,48, 0, 0, 0, 0, 0, 0, 0, 0, 6, 7, 5, 8,10,11, 9,12, 2, 3, 1, 4,
     >18,19,17,20,22,23,21,24,14,15,13,16, 0, 0, 0, 0, 0, 0, 0, 0/
      DATA (IND(39,i),i=1,64)/
     >39,38,40,37,43,42,44,41,35,34,36,33,51,50,52,49,55,54,56,53,47,46,
     >48,45, 0, 0, 0, 0, 0, 0, 0, 0, 7, 6, 8, 5,11,10,12, 9, 3, 2, 4, 1,
     >19,18,20,17,23,22,24,21,15,14,16,13, 0, 0, 0, 0, 0, 0, 0, 0/
      DATA (IND(40,i),i=1,64)/
     >40,37,39,38,44,41,43,42,36,33,35,34,52,49,51,50,56,53,55,54,48,45,
     >47,46, 0, 0, 0, 0, 0, 0, 0, 0, 8, 5, 7, 6,12, 9,11,10, 4, 1, 3, 2,
     >20,17,19,18,24,21,23,22,16,13,15,14, 0, 0, 0, 0, 0, 0, 0, 0/
      DATA (IND(41,i),i=1,64)/
     >41,43,44,42,33,35,36,34,37,39,40,38,53,55,56,54,45,47,48,46,49,51,
     >52,50, 0, 0, 0, 0, 0, 0, 0, 0, 9,11,12,10, 1, 3, 4, 2, 5, 7, 8, 6,
     >21,23,24,22,13,15,16,14,17,19,20,18, 0, 0, 0, 0, 0, 0, 0, 0/
      DATA (IND(42,i),i=1,64)/
     >42,44,43,41,34,36,35,33,38,40,39,37,54,56,55,53,46,48,47,45,50,52,
     >51,49, 0, 0, 0, 0, 0, 0, 0, 0,10,12,11, 9, 2, 4, 3, 1, 6, 8, 7, 5,
     >22,24,23,21,14,16,15,13,18,20,19,17, 0, 0, 0, 0, 0, 0, 0, 0/
      DATA (IND(43,i),i=1,64)/
     >43,41,42,44,35,33,34,36,39,37,38,40,55,53,54,56,47,45,46,48,51,49,
     >50,52, 0, 0, 0, 0, 0, 0, 0, 0,11, 9,10,12, 3, 1, 2, 4, 7, 5, 6, 8,
     >23,21,22,24,15,13,14,16,19,17,18,20, 0, 0, 0, 0, 0, 0, 0, 0/
      DATA (IND(44,i),i=1,64)/
     >44,42,41,43,36,34,33,35,40,38,37,39,56,54,53,55,48,46,45,47,52,50,
     >49,51, 0, 0, 0, 0, 0, 0, 0, 0,12,10, 9,11, 4, 2, 1, 3, 8, 6, 5, 7,
     >24,22,21,23,16,14,13,15,20,18,17,19, 0, 0, 0, 0, 0, 0, 0, 0/
      DATA (IND(45,i),i=1,64)/
     >45,47,46,48,53,55,54,56,49,51,50,52,33,35,34,36,41,43,42,44,37,39,
     >38,40, 0, 0, 0, 0, 0, 0, 0, 0,13,15,14,16,21,23,22,24,17,19,18,20,
     > 1, 3, 2, 4, 9,11,10,12, 5, 7, 6, 8, 0, 0, 0, 0, 0, 0, 0, 0/
      DATA (IND(46,i),i=1,64)/
     >46,48,45,47,54,56,53,55,50,52,49,51,34,36,33,35,42,44,41,43,38,40,
     >37,39, 0, 0, 0, 0, 0, 0, 0, 0,14,16,13,15,22,24,21,23,18,20,17,19,
     > 2, 4, 1, 3,10,12, 9,11, 6, 8, 5, 7, 0, 0, 0, 0, 0, 0, 0, 0/
      DATA (IND(47,i),i=1,64)/
     >47,45,48,46,55,53,56,54,51,49,52,50,35,33,36,34,43,41,44,42,39,37,
     >40,38, 0, 0, 0, 0, 0, 0, 0, 0,15,13,16,14,23,21,24,22,19,17,20,18,
     > 3, 1, 4, 2,11, 9,12,10, 7, 5, 8, 6, 0, 0, 0, 0, 0, 0, 0, 0/
      DATA (IND(48,i),i=1,64)/
     >48,46,47,45,56,54,55,53,52,50,51,49,36,34,35,33,44,42,43,41,40,38,
     >39,37, 0, 0, 0, 0, 0, 0, 0, 0,16,14,15,13,24,22,23,21,20,18,19,17,
     > 4, 2, 3, 1,12,10,11, 9, 8, 6, 7, 5, 0, 0, 0, 0, 0, 0, 0, 0/
      DATA (IND(49,i),i=1,64)/
     >49,50,52,51,45,46,48,47,53,54,56,55,37,38,40,39,33,34,36,35,41,42,
     >44,43, 0, 0, 0, 0, 0, 0, 0, 0,17,18,20,19,13,14,16,15,21,22,24,23,
     > 5, 6, 8, 7, 1, 2, 4, 3, 9,10,12,11, 0, 0, 0, 0, 0, 0, 0, 0/
      DATA (IND(50,i),i=1,64)/
     >50,49,51,52,46,45,47,48,54,53,55,56,38,37,39,40,34,33,35,36,42,41,
     >43,44, 0, 0, 0, 0, 0, 0, 0, 0,18,17,19,20,14,13,15,16,22,21,23,24,
     > 6, 5, 7, 8, 2, 1, 3, 4,10, 9,11,12, 0, 0, 0, 0, 0, 0, 0, 0/
      DATA (IND(51,i),i=1,64)/
     >51,52,50,49,47,48,46,45,55,56,54,53,39,40,38,37,35,36,34,33,43,44,
     >42,41, 0, 0, 0, 0, 0, 0, 0, 0,19,20,18,17,15,16,14,13,23,24,22,21,
     > 7, 8, 6, 5, 3, 4, 2, 1,11,12,10, 9, 0, 0, 0, 0, 0, 0, 0, 0/
      DATA (IND(52,i),i=1,64)/
     >52,51,49,50,48,47,45,46,56,55,53,54,40,39,37,38,36,35,33,34,44,43,
     >41,42, 0, 0, 0, 0, 0, 0, 0, 0,20,19,17,18,16,15,13,14,24,23,21,22,
     > 8, 7, 5, 6, 4, 3, 1, 2,12,11, 9,10, 0, 0, 0, 0, 0, 0, 0, 0/
      DATA (IND(53,i),i=1,64)/
     >53,56,55,54,49,52,51,50,45,48,47,46,41,44,43,42,37,40,39,38,33,36,
     >35,34, 0, 0, 0, 0, 0, 0, 0, 0,21,24,23,22,17,20,19,18,13,16,15,14,
     > 9,12,11,10, 5, 8, 7, 6, 1, 4, 3, 2, 0, 0, 0, 0, 0, 0, 0, 0/
      DATA (IND(54,i),i=1,64)/
     >54,55,56,53,50,51,52,49,46,47,48,45,42,43,44,41,38,39,40,37,34,35,
     >36,33, 0, 0, 0, 0, 0, 0, 0, 0,22,23,24,21,18,19,20,17,14,15,16,13,
     >10,11,12, 9, 6, 7, 8, 5, 2, 3, 4, 1, 0, 0, 0, 0, 0, 0, 0, 0/
      DATA (IND(55,i),i=1,64)/
     >55,54,53,56,51,50,49,52,47,46,45,48,43,42,41,44,39,38,37,40,35,34,
     >33,36, 0, 0, 0, 0, 0, 0, 0, 0,23,22,21,24,19,18,17,20,15,14,13,16,
     >11,10, 9,12, 7, 6, 5, 8, 3, 2, 1, 4, 0, 0, 0, 0, 0, 0, 0, 0/
      DATA (IND(56,i),i=1,64)/
     >56,53,54,55,52,49,50,51,48,45,46,47,44,41,42,43,40,37,38,39,36,33,
     >34,35, 0, 0, 0, 0, 0, 0, 0, 0,24,21,22,23,20,17,18,19,16,13,14,15,
     >12, 9,10,11, 8, 5, 6, 7, 4, 1, 2, 3, 0, 0, 0, 0, 0, 0, 0, 0/
      DATA (IND(57,i),i=1,64)/
     >57,63,61,59, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     > 0, 0,58,36,60,33,62,34,64,35,25,31,29,27, 0, 0, 0, 0, 0, 0, 0, 0,
     > 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,26, 4,28, 1,30, 2,32, 3/
      DATA (IND(58,i),i=1,64)/
     >58,64,62,60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     > 0, 0,36,59,33,57,34,63,35,61,26,32,30,28, 0, 0, 0, 0, 0, 0, 0, 0,
     > 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4,27, 1,25, 2,31, 3,29/
      DATA (IND(59,i),i=1,64)/
     >59,61,63,57, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     > 0, 0,60,33,58,36,64,35,62,34,27,29,31,25, 0, 0, 0, 0, 0, 0, 0, 0,
     > 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,28, 1,26, 4,32, 3,30, 2/
      DATA (IND(60,i),i=1,64)/
     >60,62,64,58, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     > 0, 0,33,57,36,59,35,61,34,63,28,30,32,26, 0, 0, 0, 0, 0, 0, 0, 0,
     > 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,25, 4,27, 3,29, 2,31/
      DATA (IND(61,i),i=1,64)/
     >61,59,57,63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     > 0, 0,35,64,34,62,33,60,36,58,29,27,25,31, 0, 0, 0, 0, 0, 0, 0, 0,
     > 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3,32, 2,30, 1,28, 4,26/
      DATA (IND(62,i),i=1,64)/
     >62,60,58,64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     > 0, 0,61,35,63,34,57,33,59,36,30,28,26,32, 0, 0, 0, 0, 0, 0, 0, 0,
     > 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,29, 3,31, 2,25, 1,27, 4/
      DATA (IND(63,i),i=1,64)/
     >63,57,59,61, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     > 0, 0,34,62,35,64,36,58,33,60,31,25,27,29, 0, 0, 0, 0, 0, 0, 0, 0,
     > 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2,30, 3,32, 4,26, 1,28/
      DATA (IND(64,i),i=1,64)/
     >64,58,60,62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     > 0, 0,63,34,61,35,59,36,57,33,32,26,28,30, 0, 0, 0, 0, 0, 0, 0, 0,
     > 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,31, 2,29, 3,27, 4,25, 1/
      DO IG=1,64
        DO IG1=1,64
          IN(IG,IG1)=IND(IG,IG1)
        ENDDO
      ENDDO
      end
c
      subroutine pntgrpdat(symnm_i,nop,nrepr,igopcl,rprnm,chi_irr,igind
     $     ,lun)
c
      implicit double precision (a-h,o-z)
      parameter(er=0.5d0,ei=0.866025403784439d0) !sqrt(3)/2
      parameter(erm=-er,eim=-ei)
c$$$      parameter(erm=-0.5d0,eim=-0.866025403784439d0) !sqrt(3)/2
C      include 'SYM.FI'
      parameter (MXGROUP=32)            ! number of groups
      parameter (MXRP=12)               ! number of irreducible representations
      parameter (MXDIM=3)               ! largest dimension of a representation
      parameter (MXOPER=48)             ! number of symmetry operations

c
      character*(*) symnm_i
      character*4 symnm,symnm_d(MXGROUP),rprnm(MXRP)
      dimension igopcl(*)
      complex*16 chi_irr(MXRP,*)
c
      dimension nrepr_d(MXGROUP),ind_d(MXGROUP),igopcl_d(MXRP,MXGROUP)
      dimension chiir_d(MXRP,MXRP,MXGROUP),chiir_i(MXRP,MXRP,23:MXGROUP)
      character*4 rprnm_d(MXRP,MXGROUP)
c C2v
      data symnm_d(1)/'c2v '/,nrepr_d(1)/4/,ind_d(1)/200001/
c E,C2z,Svx,Svy
      data (igopcl_d(i,1),i=1,4)/1,4,35,34/
      data (rprnm_d(i,1),i=1,4)/'A1  ','B1  ','A2  ','B2  '/
      data ((chiir_d(i,j,1),i=1,4),j=1,4)/
     $     1,  1,  1,  1,
     $     1, -1, -1,  1,
     $     1,  1, -1, -1,
     $     1, -1,  1, -1/
c C3v
      data symnm_d(2)/'c3v '/,nrepr_d(2)/3/,ind_d(2)/300020/
c E,2C3,3Sv
      data (igopcl_d(i,2),i=1,3)/1,26,34/
      data (rprnm_d(i,2),i=1,3)/'A1  ','A2  ','E  '/
      data ((chiir_d(i,j,2),i=1,3),j=1,3)/
     $     1,  1,  1,
     $     1,  1, -1,
     $     2, -1,  0/
c C4v
      data symnm_d(3)/'c4v '/,nrepr_d(3)/5/,ind_d(3)/400201/
c E,C2z,2C4z,2Svx,2Sdxy
      data (igopcl_d(i,3),i=1,5)/1,4,14,35,45/
      data (rprnm_d(i,3),i=1,5)/'A1  ','A2  ','B1  ','B2  ','E   '/
      data ((chiir_d(i,j,3),i=1,5),j=1,5)/
     $     1,  1,  1,  1,  1,
     $     1,  1,  1, -1, -1,
     $     1,  1, -1,  1, -1,
     $     1,  1, -1, -1,  1,
     $     2, -2,  0,  0,  0/
c D2h
      data symnm_d(4)/'d2h '/,nrepr_d(4)/8/,ind_d(4)/310003/
c E,C2z,C2y,C2x,I,Shz,Sdy,Sdx
      data (igopcl_d(i,4),i=1,8)/1,4,2,3,33,36,34,35/
      data (rprnm_d(i,4),i=1,8)
     $     /'A1g ','A1u ','B1g ','B1u ','B2g ','B2u ','B3g ','B3u '/
      data ((chiir_d(i,j,4),i=1,8),j=1,8)/
     $     1,  1,  1,  1,  1,  1,  1,  1, 
     $     1,  1,  1,  1, -1, -1, -1, -1,
     $     1,  1, -1, -1,  1,  1, -1, -1,
     $     1,  1, -1, -1, -1, -1,  1,  1,
     $     1, -1,  1, -1,  1, -1,  1, -1,
     $     1, -1,  1, -1, -1,  1, -1,  1,
     $     1, -1, -1,  1,  1, -1, -1,  1,
     $     1, -1, -1,  1, -1,  1,  1, -1/
c D3h
      data symnm_d(5)/'d3h '/,nrepr_d(5)/6/,ind_d(5)/200400023/
c E,Sh,2C3,2S3,3C2x,3Sv
      data (igopcl_d(i,5),i=1,6)/1,36,26,60,30,34/
      data (rprnm_d(i,5),i=1,6)
     $     /'A1  ','A2  ','A3  ','A4  ','E1  ','E2  '/
      data ((chiir_d(i,j,5),i=1,6),j=1,6)/
     $     1,  1,  1,  1,  1,  1,
     $     1,  1,  1,  1, -1, -1,
     $     1, -1,  1, -1,  1, -1,
     $     1, -1,  1, -1, -1,  1,
     $     2, -2, -1,  1,  0,  0,
     $     2,  2, -1, -1,  0,  0/
c D4h
      data symnm_d(6)/'d4h '/,nrepr_d(6)/10/,ind_d(6)/20510205/
c E,C2z,2C4z,2C2x,2C2xy,I,Shz,2S4z,2Svx,2Sdxy
      data (igopcl_d(i,6),i=1,10)/1,4,14,3,13,33,36,46,35,45/
      data (rprnm_d(i,6),i=1,10)/'A1g ','A1u ','A2g ','A2u '
     $     ,'B1g ','B1u ','B2g ','B2u ','Eg  ','Eu  '/
      data ((chiir_d(i,j,6),i=1,10),j=1,10)/
     $     1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 
     $     1,  1,  1,  1,  1, -1, -1, -1, -1, -1,
     $     1,  1,  1, -1, -1,  1,  1,  1, -1, -1,
     $     1,  1,  1, -1, -1, -1, -1, -1,  1,  1,
     $     1,  1, -1,  1, -1,  1,  1, -1,  1, -1,
     $     1,  1, -1,  1, -1, -1, -1,  1, -1,  1,
     $     1,  1, -1, -1,  1,  1,  1, -1, -1,  1,
     $     1,  1, -1, -1,  1, -1, -1,  1,  1, -1,
     $     2, -2,  0,  0,  0,  2, -2,  0,  0,  0,
     $     2, -2,  0,  0,  0, -2,  2,  0,  0,  0/
c D6h
      data symnm_d(7)/'d6h '/,nrepr_d(7)/12/,ind_d(7)/202712027/
c E,C2z,2C3,2C6,3C2x,3c2,I,Sh,2S3,2S6,3Sv,3Sd
      data (igopcl_d(i,7),i=1,12)/1,4,26,25,30,32,33,36,58,57,62,64/
      data (rprnm_d(i,7),i=1,12)/'A1g ','A1u ','A2g ','A2u '
     $     ,'B1g ','B1u ','B2g ','B2u ','E1g ','E1u ','E2g ','E2u '/
      data ((chiir_d(i,j,7),i=1,12),j=1,12)/
     $     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,      
     $     1,  1,  1,  1,  1,  1, -1, -1, -1, -1, -1, -1,     
     $     1,  1,  1,  1, -1, -1,  1,  1,  1,  1, -1, -1,     
     $     1,  1,  1,  1, -1, -1, -1, -1, -1, -1,  1,  1,     
     $     1, -1,  1, -1,  1, -1,  1, -1,  1, -1,  1, -1,     
     $     1, -1,  1, -1,  1, -1, -1,  1, -1,  1, -1,  1,     
     $     1, -1,  1, -1, -1,  1,  1, -1,  1, -1, -1,  1,     
     $     1, -1,  1, -1, -1,  1, -1,  1, -1,  1,  1, -1,
     $     2, -2, -1,  1,  0,  0,  2, -2, -1,  1,  0,  0,     
     $     2, -2, -1,  1,  0,  0, -2,  2,  1, -1,  0,  0, 
     $     2,  2, -1, -1,  0,  0,  2,  2, -1, -1,  0,  0,     
     $     2,  2, -1, -1,  0,  0, -2, -2,  1,  1,  0,  0/     
c D2d
      data symnm_d(8)/'d2d '/,nrepr_d(8)/5/,ind_d(8)/20200003/
c E,CS4,C2z,2C2x,2Sdxy
      data (igopcl_d(i,8),i=1,5)/1,46,4,3,45/
      data (rprnm_d(i,8),i=1,5)/'A1  ','A2  ','B1  ','B2  ','E   '/
      data ((chiir_d(i,j,8),i=1,5),j=1,5)/
     $     1,  1,  1,  1,  1,
     $     1,  1,  1, -1, -1,
     $     1, -1,  1,  1, -1,
     $     1, -1,  1, -1,  1,
     $     2,  0, -2,  0,  0/
c D3d
      data symnm_d(9)/'d3d '/,nrepr_d(9)/6/,ind_d(9)/2310023/
c E,2C3,3C2x,I,2S6,3Sv,
      data (igopcl_d(i,9),i=1,6)/1,26,29,33,58,61/
c$$$      data (igopcl_d(i,9),i=1,6)/1,26,3,33,58,35/
      data (rprnm_d(i,9),i=1,6)
     $     /'A1g ','A1u ','A2g ','A2u ','Eg  ','Eu  '/
      data ((chiir_d(i,j,9),i=1,6),j=1,6)/
     $     1,  1,  1,  1,  1,  1,
     $     1,  1,  1, -1, -1, -1,
     $     1,  1, -1,  1,  1, -1,
     $     1,  1, -1, -1, -1,  1,
     $     2, -1,  0,  2, -1,  0,
     $     2, -1,  0, -2,  1,  0/
c Td
      data symnm_d(10)/'td '/,nrepr_d(10)/5/,ind_d(10)/60600083/
c E,8C3d,3C2x,6Sdxy,6S4x
      data (igopcl_d(i,10),i=1,5)/1,8,3,45,54/
      data (rprnm_d(i,10),i=1,5)/'A1  ','A2  ','E   ','T1  ','T2  '/
      data ((chiir_d(i,j,10),i=1,5),j=1,5)/
     $     1,  1,  1,  1,  1,
     $     1,  1,  1, -1, -1,
     $     2, -1,  2,  0,  0,
     $     3,  0, -1, -1,  1,
     $     3,  0, -1,  1, -1/
c Oh
      data symnm_d(11)/'oh '/,nrepr_d(11)/10/,ind_d(11)/68910689/
c E,8C3d,3C2x,6C2xy,6C4x,I,8S6,3Shx,6Sdxy,6S4x
      data (igopcl_d(i,11),i=1,10)/1,8,3,13,22,33,40,35,45,54/
      data (rprnm_d(i,11),i=1,10)/'A1g ','A1u ','B1g ','B1u '
     $     ,'Eg  ','Eu  ','T1g ','T1u ','T2g ','T2u '/
      data ((chiir_d(i,j,11),i=1,10),j=1,10)/
     $     1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 
     $     1,  1,  1,  1,  1, -1, -1, -1, -1, -1,
     $     1,  1,  1, -1, -1,  1,  1,  1, -1, -1,
     $     1,  1,  1, -1, -1, -1, -1, -1,  1,  1,
     $     2, -1,  2,  0,  0,  2, -1,  2,  0,  0,
     $     2, -1,  2,  0,  0, -2,  1, -2,  0,  0,
     $     3,  0, -1, -1,  1,  3,  0, -1, -1,  1,
     $     3,  0, -1, -1,  1, -3,  0,  1,  1, -1,
     $     3,  0, -1,  1, -1,  3,  0, -1,  1, -1,
     $     3,  0, -1,  1, -1, -3,  0,  1, -1,  1/
c C1
      data symnm_d(12)/'c1 '/,nrepr_d(12)/1/,ind_d(12)/0/
c E
      data (igopcl_d(i,12),i=1,1)/1/
      data (rprnm_d(i,12),i=1,1)/'A   '/
      data ((chiir_d(i,j,12),i=1,1),j=1,1)/
     $     1/
c Ci
      data symnm_d(13)/'ci '/,nrepr_d(13)/2/,ind_d(13)/10000/
c E,I
      data (igopcl_d(i,13),i=1,2)/1,33/
      data (rprnm_d(i,13),i=1,2)/'Ag  ','Au  '/
      data ((chiir_d(i,j,13),i=1,2),j=1,2)/
     $     1,  1,
     $     1, -1/
c C2
      data symnm_d(14)/'c2 '/,nrepr_d(14)/2/,ind_d(14)/1/
c E,C2z
      data (igopcl_d(i,14),i=1,2)/1,4/
      data (rprnm_d(i,14),i=1,2)/'A   ','B   '/
      data ((chiir_d(i,j,14),i=1,2),j=1,2)/
     $     1,  1,
     $     1, -1/
c Cs
      data symnm_d(15)/'cs '/,nrepr_d(15)/2/,ind_d(15)/100000/
c E,Sh
      data (igopcl_d(i,15),i=1,2)/1,36/
      data (rprnm_d(i,15),i=1,2)/'A1  ','A2  '/
      data ((chiir_d(i,j,15),i=1,2),j=1,2)/
     $     1,  1,
     $     1, -1/
c C2h
      data symnm_d(16)/'c2h '/,nrepr_d(16)/4/,ind_d(16)/110001/
c E,C2,Sh,I
      data (igopcl_d(i,16),i=1,4)/1,4,33,36/
      data (rprnm_d(i,16),i=1,4)/'Ag  ','Bg  ','Au  ','Bu  '/
      data ((chiir_d(i,j,16),i=1,4),j=1,4)/
     $     1,  1,  1,  1,
     $     1, -1,  1, -1,
     $     1,  1, -1, -1,
     $     1, -1, -1,  1/
c D2
      data symnm_d(17)/'d2  '/,nrepr_d(17)/4/,ind_d(17)/3/
c E,C2z,C2y,C2x
      data (igopcl_d(i,17),i=1,4)/1,4,2,3/
      data (rprnm_d(i,17),i=1,4)/'A1  ','B1  ','B2  ','B3  '/
      data ((chiir_d(i,j,17),i=1,4),j=1,4)/
     $     1,  1,  1,  1,
     $     1,  1, -1, -1,
     $     1, -1,  1, -1,
     $     1, -1, -1,  1/
c D3
      data symnm_d(18)/'d3  '/,nrepr_d(18)/3/,ind_d(18)/23/
c E,2C3,3C2x
      data (igopcl_d(i,18),i=1,3)/1,26,29/
      data (rprnm_d(i,18),i=1,3)/'A1  ','A2  ','E  '/
      data ((chiir_d(i,j,18),i=1,3),j=1,3)/
     $     1,  1,  1,
     $     1,  1, -1,
     $     2, -1,  0/
c D4
      data symnm_d(19)/'d4  '/,nrepr_d(19)/5/,ind_d(19)/205/
c E,C2z,2C4z,2C2x,2C2xy
      data (igopcl_d(i,19),i=1,5)/1,4,14,3,13/
      data (rprnm_d(i,19),i=1,5)/'A1  ','A2  ','B1  ','B2  ','E   '/
      data ((chiir_d(i,j,19),i=1,5),j=1,5)/
     $     1,  1,  1,  1,  1,
     $     1,  1,  1, -1, -1,
     $     1,  1, -1,  1, -1,
     $     1,  1, -1, -1,  1,
     $     2, -2,  0,  0,  0/
c D6
      data symnm_d(20)/'d6  '/,nrepr_d(20)/6/,ind_d(20)/2027/
c E,C2z,2C3,2C6,3C2x,3c2
      data (igopcl_d(i,20),i=1,6)/1,4,26,25,30,32/
      data (rprnm_d(i,20),i=1,6)
     $     /'A1  ','A2  ','B1  ','B2  ','E1  ','E2  '/
      data ((chiir_d(i,j,20),i=1,6),j=1,6)/
     $     1,  1,  1,  1,  1,  1,
     $     1,  1,  1,  1, -1, -1,
     $     1, -1,  1, -1,  1, -1,
     $     1, -1,  1, -1, -1,  1,
     $     2, -2, -1,  1,  0,  0,
     $     2,  2, -1, -1,  0,  0/
c C6v
      data symnm_d(21)/'c6v '/,nrepr_d(21)/6/,ind_d(21)/602021/
c E,C2z,2C3,2C6,3Sv,3Sd,
      data (igopcl_d(i,21),i=1,6)/1,4,26,25,64,62/
      data (rprnm_d(i,21),i=1,6)
     $     /'A1  ','A2  ','B1  ','B2  ','E1  ','E2  '/
      data ((chiir_d(i,j,21),i=1,6),j=1,6)/
     $     1,  1,  1,  1,  1,  1,
     $     1,  1,  1,  1, -1, -1,
     $     1, -1,  1, -1, -1,  1,
     $     1, -1,  1, -1,  1, -1,
     $     2,  2, -1, -1,  0,  0,
     $     2, -2, -1,  1,  0,  0/
c O
      data symnm_d(22)/'o  '/,nrepr_d(22)/5/,ind_d(22)/689/
c E,8C3d,3C2x,6C2xy,6C4x
      data (igopcl_d(i,22),i=1,5)/1,8,3,13,22/
      data (rprnm_d(i,22),i=1,5)/'A1  ','A2  ','E   ','T1  ','T2  '/
      data ((chiir_d(i,j,22),i=1,5),j=1,5)/
     $     1,  1,  1,  1,  1,
     $     1,  1,  1, -1, -1,
     $     2, -1,  2,  0,  0,
     $     3,  0, -1, -1,  1,
     $     3,  0, -1,  1, -1/
c C4
      data symnm_d(23)/'c4  '/,nrepr_d(23)/-4/,ind_d(23)/201/
c E,C1/4,C2,C3/4
      data (igopcl_d(i,23),i=1,4)/1,14,4,15/
      data (rprnm_d(i,23),i=1,4)/'A   ','B   ','E   ','E   '/
      data ((chiir_d(i,j,23),i=1,4),j=1,4)/
     $     1,  1,  1,  1,
     $     1, -1,  1, -1,
     $     1,  0, -1,  0,
     $     1,  0, -1,  0/
      data ((chiir_i(i,j,23),i=1,4),j=1,4)/
     $     0,  0,  0,  0,
     $     0,  0,  0,  0,
     $     0,  1,  0, -1,
     $     0, -1,  0,  1/
c S4
      data symnm_d(24)/'s4  '/,nrepr_d(24)/-4/,ind_d(24)/20000001/
c E,S1/4,C2,S3/4
      data (igopcl_d(i,24),i=1,4)/1,46,4,47/
      data (rprnm_d(i,24),i=1,4)/'A   ','B   ','E   ','E   '/
      data ((chiir_d(i,j,24),i=1,4),j=1,4)/
     $     1,  1,  1,  1,
     $     1, -1,  1, -1,
     $     1,  0, -1,  0,
     $     1,  0, -1,  0/
      data ((chiir_i(i,j,24),i=1,4),j=1,4)/
     $     0,  0,  0,  0,
     $     0,  0,  0,  0,
     $     0,  1,  0, -1,
     $     0, -1,  0,  1/
c C3
      data symnm_d(25)/'c3  '/,nrepr_d(25)/-3/,ind_d(25)/20/
c E,C1/3,C2/3
      data (igopcl_d(i,25),i=1,3)/1,26,27/
      data (rprnm_d(i,25),i=1,3)/'A   ','E   ','E   '/
      data ((chiir_d(i,j,25),i=1,3),j=1,3)/
     $     1,   1,   1,
     $     1, erm, erm,
     $     1, erm, erm/
      data ((chiir_i(i,j,25),i=1,3),j=1,3)/
     $     0,   0,   0,
     $     0, eim,  ei,
     $     0,  ei, eim/
c C3h
      data symnm_d(26)/'c3h '/,nrepr_d(26)/-6/,ind_d(26)/200100020/
c E,C1/3,C2/3,Sh,S1/3,S2/3
      data (igopcl_d(i,26),i=1,6)/1,26,27,36,60,57/
      data (rprnm_d(i,26),i=1,6)
     $     /'A1  ','A2  ','E1  ','E1  ','E2  ','E2  '/
      data ((chiir_d(i,j,26),i=1,6),j=1,6)/
     $     1,   1,   1,   1,   1,   1,
     $     1,   1,   1,  -1,  -1,  -1,
     $     1, erm, erm,   1, erm, erm,
     $     1, erm, erm,   1, erm, erm,
     $     1, erm, erm,  -1,  er,  er,
     $     1, erm, erm,  -1,  er,  er/
      data ((chiir_i(i,j,26),i=1,6),j=1,6)/
     $     0,   0,   0,   0,   0,   0,
     $     0,   0,   0,   0,   0,   0,
     $     0, eim,  ei,   0, eim,  ei,
     $     0,  ei, eim,   0,  ei, eim,
     $     0, eim,  ei,   0,  ei, eim,
     $     0,  ei, eim,   0, eim,  ei/
c C4h
      data symnm_d(27)/'c4h '/,nrepr_d(27)/-8/,ind_d(27)/20110201/
c E,C1/4,C2,C3/4,I,S1/4,Sh,S3/4
      data (igopcl_d(i,27),i=1,8)/1,14,4,15,33,46,36,47/
      data (rprnm_d(i,27),i=1,8)
     $     /'Ag  ','Au  ','Bg  ','Bu  ','Eg  ','Eg  ','Eu  ','Eu  '/
      data ((chiir_d(i,j,27),i=1,8),j=1,8)/
     $     1,  1,  1,  1,  1,  1,  1,  1,
     $     1,  1,  1,  1, -1, -1, -1, -1,
     $     1, -1,  1, -1,  1, -1,  1, -1,
     $     1, -1,  1, -1, -1,  1, -1,  1,
     $     1,  0, -1,  0,  1,  0, -1,  0,
     $     1,  0, -1,  0,  1,  0, -1,  0,
     $     1,  0, -1,  0, -1,  0,  1,  0,
     $     1,  0, -1,  0, -1,  0,  1,  0/
      data ((chiir_i(i,j,27),i=1,8),j=1,8)/
     $     0,  0,  0,  0,  0,  0,  0,  0,
     $     0,  0,  0,  0,  0,  0,  0,  0,
     $     0,  0,  0,  0,  0,  0,  0,  0,
     $     0,  0,  0,  0,  0,  0,  0,  0,
     $     0,  1,  0, -1,  0,  1,  0, -1,
     $     0, -1,  0,  1,  0, -1,  0,  1,
     $     0,  1,  0, -1,  0, -1,  0,  1,
     $     0, -1,  0,  1,  0,  1,  0, -1/
c S6
      data symnm_d(28)/'s6  '/,nrepr_d(28)/-6/,ind_d(28)/2010020/
c E,C1/3,C2/3,I,S1/3,S2/3
      data (igopcl_d(i,28),i=1,6)/1,26,27,33,58,59/
      data (rprnm_d(i,28),i=1,6)
     $     /'Ag  ','Au  ','Eg  ','Eg  ','Eu  ','Eu  '/
      data ((chiir_d(i,j,28),i=1,6),j=1,6)/
     $     1,  1,  1,  1,  1,  1,
     $     1,  1,  1, -1, -1, -1,
     $     1,erm,erm,  1,erm,erm,
     $     1,erm,erm,  1,erm,erm,
     $     1,erm,erm, -1, er, er,
     $     1,erm,erm, -1, er, er/
      data ((chiir_i(i,j,28),i=1,6),j=1,6)/
     $     0,  0,  0,  0,  0,  0,
     $     0,  0,  0,  0,  0,  0,
     $     0,eim, ei,  0,eim, ei,
     $     0, ei,eim,  0, ei,eim,
     $     0,eim, ei,  0, ei,eim,
     $     0, ei,eim,  0,eim, ei/
c C6
      data symnm_d(29)/'c6  '/,nrepr_d(29)/-6/,ind_d(29)/2021/
c E,C1/6,C1/3,C2,C2/3,C5/3
      data (igopcl_d(i,29),i=1,6)/1,25,26,4,27,28/
      data (rprnm_d(i,29),i=1,6)
     $     /'A   ','B   ','E1  ','E1  ','E2  ','E2  '/
      data ((chiir_d(i,j,29),i=1,6),j=1,6)/
     $     1,  1,  1,  1,  1,  1,
     $     1, -1,  1, -1,  1, -1,
     $     1, er,erm, -1,erm, er,
     $     1, er,erm, -1,erm, er,
     $     1,erm,erm,  1,erm,erm,
     $     1,erm,erm,  1,erm,erm/
      data ((chiir_i(i,j,29),i=1,6),j=1,6)/
     $     0,  0,  0,  0,  0,  0,
     $     0,  0,  0,  0,  0,  0,
     $     0, ei, ei,  0,eim,eim,
     $     0,eim,eim,  0, ei, ei,
     $     0, ei,eim,  0, ei,eim,
     $     0,eim, ei,  0,eim, ei/
c C6h=C6*Ci
      data symnm_d(30)/'c6h '/,nrepr_d(30)/-12/,ind_d(30)/202112021/
c E,C1/6,C1/3,C2,C2/3,C5/3,I,S1/6,S1/3,Sh,S2/3,S5/3
      data (igopcl_d(i,30),i=1,12)/1,25,26,4,27,28,33,57,58,36,59,60/
      data (rprnm_d(i,30),i=1,12)/'Ag  ','Au  ','Bg  ','Bu  '
     $     ,'E1g ','E1g ','E1u ','E1u ','E2g ','E2g ','E2u ','E2u '/
      data ((chiir_d(i,j,30),i=1,12),j=1,12)/
     $     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     $     1,  1,  1,  1,  1,  1, -1, -1, -1, -1, -1, -1,
     $     1, -1,  1, -1,  1, -1,  1, -1,  1, -1,  1, -1,
     $     1, -1,  1, -1,  1, -1, -1,  1, -1,  1, -1,  1,
     $     1, er,erm, -1,erm, er,  1, er,erm, -1,erm, er,
     $     1, er,erm, -1,erm, er,  1, er,erm, -1,erm, er,
     $     1, er,erm, -1,erm, er, -1,erm, er,  1, er,erm,
     $     1, er,erm, -1,erm, er, -1,erm, er,  1, er,erm,
     $     1,erm,erm,  1,erm,erm,  1,erm,erm,  1,erm,erm,
     $     1,erm,erm,  1,erm,erm,  1,erm,erm,  1,erm,erm,
     $     1,erm,erm,  1,erm,erm, -1, er, er, -1, er, er,
     $     1,erm,erm,  1,erm,erm, -1, er, er, -1, er, er/
      data ((chiir_i(i,j,30),i=1,12),j=1,12)/
     $     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     $     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     $     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     $     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     $     0, ei, ei,  0,eim,eim,  0, ei, ei,  0,eim,eim,
     $     0,eim,eim,  0, ei, ei,  0,eim,eim,  0, ei, ei,
     $     0, ei, ei,  0,eim,eim,  0,eim,eim,  0, ei, ei,
     $     0,eim,eim,  0, ei, ei,  0, ei, ei,  0,eim,eim,
     $     0, ei,eim,  0, ei,eim,  0, ei,eim,  0, ei,eim,
     $     0,eim, ei,  0,eim, ei,  0,eim, ei,  0,eim, ei,
     $     0, ei,eim,  0, ei,eim,  0,eim, ei,  0,eim, ei,
     $     0,eim, ei,  0,eim, ei,  0, ei,eim,  0, ei,eim/
c T
      data symnm_d(31)/'t   '/,nrepr_d(31)/-4/,ind_d(31)/83/
c E,4C1/3d,4C2/3d,3C2x
      data (igopcl_d(i,31),i=1,4)/1,8,10,3/
      data (rprnm_d(i,31),i=1,4)/'A   ','E   ','E   ','T   '/
      data ((chiir_d(i,j,31),i=1,4),j=1,4)/
     $     1,  1,  1,  1,
     $     1,erm,erm,  1,
     $     1,erm,erm,  1,
     $     3,  0,  0, -1/
      data ((chiir_i(i,j,31),i=1,4),j=1,4)/
     $     0,  0,  0,  0,
     $     0, ei,eim,  0,
     $     0,eim, ei,  0,
     $     0,  0,  0,  0/
c Th
      data symnm_d(32)/'th  '/,nrepr_d(32)/-8/,ind_d(32)/8310083/
c E,4C1/3d,4C2/3d,3C2x,I,4I*C1/3d,4I*C2/3d,4S2/6d,3Shx
      data (igopcl_d(i,32),i=1,8)/1,8,10,3,33,40,42,35/
      data (rprnm_d(i,32),i=1,8)
     $     /'Ag  ','Au  ','Eg  ','Eg  ','Eu  ','Eu  ','Tg  ','Tu  '/
      data ((chiir_d(i,j,32),i=1,8),j=1,8)/
     $     1,  1,  1,  1,  1,  1,  1,  1,
     $     1,  1,  1,  1, -1, -1, -1, -1,
     $     1,erm,erm,  1,  1,erm,erm,  1,
     $     1,erm,erm,  1,  1,erm,erm,  1,
     $     1,erm,erm,  1, -1, er, er, -1,
     $     1,erm,erm,  1, -1, er, er, -1,
     $     3,  0,  0, -1,  3,  0,  0, -1,
     $     3,  0,  0, -1, -3,  0,  0,  1/
      data ((chiir_i(i,j,32),i=1,8),j=1,8)/
     $     0,  0,  0,  0,  0,  0,  0,  0,
     $     0,  0,  0,  0,  0,  0,  0,  0,
     $     0, ei,eim,  0,  0, ei,eim,  0,
     $     0,eim, ei,  0,  0,eim, ei,  0,
     $     0, ei,eim,  0,  0,eim, ei,  0,
     $     0,eim, ei,  0,  0, ei,eim,  0,
     $     0,  0,  0,  0,  0,  0,  0,  0,
     $     0,  0,  0,  0,  0,  0,  0,  0/
c
      indonly=0
      goto 10
c
      entry pntgrpind(symnm_i,igind,lun)
c returns group index only
      indonly=1
c
 10   continue
      symnm=symnm_i
      call to_lower(symnm)
c$$$      print *,'symnm_i,symnm',symnm_i,symnm
      igrp=1
      do while(igrp.le.MXGROUP.and.symnm_d(igrp).ne.symnm)
        igrp=igrp+1
      enddo
c$$$      write(lun,*)'symnm,igrp   ',symnm,igrp
      if(igrp.gt.MXGROUP)then
        write(lun,*)'PNTGRP: No data for group ',symnm_i
        stop
      endif
      igind=ind_d(igrp)
      if(indonly.eq.1)return
      nrepr=nrepr_d(igrp)
      if(nrepr.gt.0)then
        is_complex=0
      else
        is_complex=1
        nrepr=-nrepr
      endif
      nop=0
      do ir=1,nrepr
        igopcl(ir)=igopcl_d(ir,igrp)
        rprnm(ir)=rprnm_d(ir,igrp)
        ndim=chiir_d(1,ir,igrp)
        nop=nop+ndim**2
        if(is_complex.eq.0)then
          do icl=1,nrepr
            chi_irr(icl,ir)=dcmplx(chiir_d(icl,ir,igrp),0.d0)
          enddo
        else
          do icl=1,nrepr
            chi_irr(icl,ir)=
     $           dcmplx(chiir_d(icl,ir,igrp),chiir_i(icl,ir,igrp))
          enddo
        endif
      enddo
      return
c 
      entry group_by_ind(igind,symnm_i,lun)
c find group with a given index
      do igrp=1,mxgroup
        if(igind.eq.ind_d(igrp))then
          symnm_i=symnm_d(igrp)
          ic=ichar(symnm_i(1:1))-32
          symnm_i(1:1)=char(ic)
          return
        endif
      enddo
      write(lun,1000)igind
 1000 format(' Group with index ',i8,' has not been found')
      symnm_i='non '
      end
c
      subroutine to_lower(s)
      character*(*) s
c
      do i=1,len(s)
        ic=ichar(s(i:i))
        if(ic.ge.65.and.ic.le.90)then
          ic=ic+32
          s(i:i)=char(ic)
        endif
      enddo
      end
c
      function iopind(iop)
      integer e,s2,s3,s4,s6
      parameter (e=0,s2=1,s3=10,s4=100,s6=1000,ie=10000,is2=100 000,
     $     is3=1 000 000, is4=10 000 000, is6=100 000 000)
      dimension idata(64)
      data idata
     $     /e,s2,s2,s2,s3,s3,s3,s3,s3,s3,s3,s3,s2,s4,s4,s2,s2,s2,s4,s4
     $     ,s2,s4,s2,s4,s6,s3,s3,s6,s2,s2,s2,s2,ie,is2,is2,is2,is3,is3
     $     ,is3,is3,is3,is3,is3,is3,is2,is4,is4,is2,is2,is2,is4,is4,is2
     $     ,is4,is2,is4,is6,is3,is3,is6,is2,is2,is2,is2/
c
      iopind=idata(iop)
      end
      subroutine spacegroup(b0,ini,IERR)
      parameter (nspcgroups=502)
      character*55 B(nspcgroups),b0*78,aorig*1,aor*1
      data
     $B(  1)/'  1 P1       C1 - 1( 1)  1 1  0 7   1 01000            '/,
     $B(  2)/'  2 P-1      CI - 1( 2)  2 0  0 7   1 33000            '/,
     $B(  3)/'  3 P2       C2 - 1( 2) 34 1  0 6   1 02000            '/,
     $B(  4)/'  3 P121     C2 - 1( 2) 36 1  0 6   1 04000            '/,
     $B(  5)/'  4 P2_1     C2 - 2( 2) 34 1  0 6   1 02060            '/,
     $B(  6)/'  4 P12_11   C2 - 2( 2) 36 1  0 6   1 04006            '/,
     $B(  7)/'  5 C2       C2 - 3( 2) 34 1  0 6   1 02000            '/,
     $B(  8)/'  5 A2       C2 - 3( 2) 34 1  0 6   1 02000            '/,
     $B(  9)/'  5 I2       C2 - 3( 2) 34 1  0 6   1 02000            '/,
     $B( 10)/'  5 C121     C2 - 3( 2) 36 1  0 6   1 04000            '/,
     $B( 11)/'  5 A121     C2 - 3( 2) 36 1  0 6   1 04000            '/,
     $B( 12)/'  5 I121     C2 - 3( 2) 36 1  0 6   1 04000            '/,
     $B( 13)/'  6 PM       CS - 1( 2) 41 1  0 6   1 34000            '/,
     $B( 14)/'  6 P1M1     CS - 1( 2) 41 1  0 6   1 36000            '/,
     $B( 15)/'  7 PC       CS - 2( 2) 41 1  0 6   1 34006            '/,
     $B( 16)/'  7 PA       CS - 2( 2) 41 1  0 6   1 34600            '/,
     $B( 17)/'  7 PN       CS - 2( 2) 41 1  0 6   1 34606            '/,
     $B( 18)/'  7 P1C1     CS - 2( 2) 41 1  0 6   1 36006            '/,
     $B( 19)/'  7 P1A1     CS - 2( 2) 41 1  0 6   1 36600            '/,
     $B( 20)/'  7 P1N1     CS - 2( 2) 41 1  0 6   1 36606            '/
      data
     $B( 21)/'  8 CM       CS - 3( 2) 41 1  0 6   1 34000            '/,
     $B( 22)/'  8 AM       CS - 3( 2) 41 1  0 6   1 34000            '/,
     $B( 23)/'  8 IM       CS - 3( 2) 41 1  0 6   1 34000            '/,
     $B( 24)/'  8 C1M1     CS - 3( 2) 41 1  0 6   1 36000            '/,
     $B( 25)/'  8 A1M1     CS - 3( 2) 41 1  0 6   1 36000            '/,
     $B( 26)/'  8 I1M1     CS - 3( 2) 41 1  0 6   1 36000            '/,
     $B( 27)/'  9 CC       CS - 4( 2) 41 1  0 6   1 34006            '/,
     $B( 28)/'  9 CN       CS - 4( 2) 41 1  0 6   1 34606            '/,
     $B( 29)/'  9 AA       CS - 4( 2) 41 1  0 6   1 34600            '/,
     $B( 30)/'  9 AN       CS - 4( 2) 41 1  0 6   1 34660            '/,
     $B( 31)/'  9 IA       CS - 4( 2) 41 1  0 6   1 34600            '/,
     $B( 32)/'  9 IC       CS - 4( 2) 41 1  0 6   1 34006            '/,
     $B( 33)/'  9 C1C1     CS - 4( 2) 41 1  0 6   1 36006            '/,
     $B( 34)/'  9 C1N1     CS - 4( 2) 41 1  0 6   1 36606            '/,
     $B( 35)/'  9 A1A1     CS - 4( 2) 41 1  0 6   1 36600            '/,
     $B( 36)/'  9 A1N1     CS - 4( 2) 41 1  0 6   1 36660            '/,
     $B( 37)/'  9 I1A1     CS - 4( 2) 41 1  0 6   1 36600            '/,
     $B( 38)/'  9 I1C1     CS - 4( 2) 41 1  0 6   1 36006            '/,
     $B( 39)/' 10 P2/M     C2H- 1( 4) 35 0  0 6   2 33000 34000      '/,
     $B( 40)/' 10 P12/M1   C2H- 1( 4) 35 0  0 6   2 33000 36000      '/
      data
     $B( 41)/' 11 P2_1/M   C2H- 2( 4) 35 0  0 6   2 33000 34060      '/,
     $B( 42)/' 11 P12_1/M1 C2H- 2( 4) 35 0  0 6   2 33000 36006      '/,
     $B( 43)/' 12 C2/M     C2H- 3( 4) 35 0  0 6   2 33000 34000      '/,
     $B( 44)/' 12 A2/M     C2H- 3( 4) 35 0  0 6   2 33000 34000      '/,
     $B( 45)/' 12 I2/M     C2H- 3( 4) 35 0  0 6   2 33000 34000      '/,
     $B( 46)/' 12 C12/M1   C2H- 3( 4) 35 0  0 6   2 33000 36000      '/,
     $B( 47)/' 12 A12/M1   C2H- 3( 4) 35 0  0 6   2 33000 36000      '/,
     $B( 48)/' 12 I12/M1   C2H- 3( 4) 35 0  0 6   2 33000 36000      '/,
     $B( 49)/' 13 P2/C     C2H- 4( 4) 35 0  0 6   2 33000 34006      '/,
     $B( 50)/' 13 P2/A     C2H- 4( 4) 35 0  0 6   2 33000 34600      '/,
     $B( 51)/' 13 P2/N     C2H- 4( 4) 35 0  0 6   2 33000 34606      '/,
     $B( 52)/' 13 P12/C1   C2H- 4( 4) 35 0  0 6   2 33000 36006      '/,
     $B( 53)/' 13 P12/A1   C2H- 4( 4) 35 0  0 6   2 33000 36600      '/,
     $B( 54)/' 13 P12/N1   C2H- 4( 4) 35 0  0 6   2 33000 36606      '/,
     $B( 55)/' 14 P2_1/C   C2H- 5( 4) 35 0  0 6   2 33000 34066      '/,
     $B( 56)/' 14 P2_1/A   C2H- 5( 4) 35 0  0 6   2 33000 34660      '/,
     $B( 57)/' 14 P2_1/N   C2H- 5( 4) 35 0  0 6   2 33000 34666      '/,
     $B( 58)/' 14 P12_1/B1 C2H- 5( 4) 35 0  0 6   2 33000 36066      '/,
     $B( 59)/' 14 P12_1/A1 C2H- 5( 4) 35 0  0 6   2 33000 36606      '/,
     $B( 60)/' 14 P12_1/N1 C2H- 5( 4) 35 0  0 6   2 33000 36666      '/
      data
     $B( 61)/' 15 C2/C     C2H- 6( 4) 35 0  0 6   2 33000 34006      '/,
     $B( 62)/' 15 C2/N     C2H- 6( 4) 35 0  0 6   2 33000 34606      '/,
     $B( 63)/' 15 A2/A     C2H- 6( 4) 35 0  0 6   2 33000 34600      '/,
     $B( 64)/' 15 A2/N     C2H- 6( 4) 35 0  0 6   2 33000 34660      '/,
     $B( 65)/' 15 I2/A     C2H- 6( 4) 35 0  0 6   2 33000 34600      '/,
     $B( 66)/' 15 I2/C     C2H- 6( 4) 35 0  0 6   2 33000 34006      '/,
     $B( 67)/' 15 C12/C1   C2H- 6( 4) 35 0  0 6   2 33000 36006      '/,
     $B( 68)/' 15 C12/N1   C2H- 6( 4) 35 0  0 6   2 33000 36606      '/,
     $B( 69)/' 15 A12/A1   C2H- 6( 4) 35 0  0 6   2 33000 36600      '/,
     $B( 70)/' 15 A12/N1   C2H- 6( 4) 35 0  0 6   2 33000 36660      '/,
     $B( 71)/' 15 I12/A1   C2H- 6( 4) 35 0  0 6   2 33000 36600      '/,
     $B( 72)/' 15 I12/C1   C2H- 6( 4) 35 0  0 6   2 33000 36006      '/,
     $B( 73)/' 16 P222     D2 - 1( 4)  8 1  0 5   2 03000 02000      '/,
     $B( 74)/' 17 P222_1   D2 - 2( 4)  8 1  0 5   2 03000 02006      '/,
     $B( 75)/' 17 P22_12   D2 - 2( 4)  8 1  0 5   2 03000 02060      '/,
     $B( 76)/' 17 P2_122   D2 - 2( 4)  8 1  0 5   2 03600 02000      '/,
     $B( 77)/' 18 P22_12_1 D2 - 3( 4)  8 1  0 5   2 03000 02066      '/,
     $B( 78)/' 18 P2_122_1 D2 - 3( 4)  8 1  0 5   2 03606 02000      '/,
     $B( 79)/' 18 P2_12_12 D2 - 3( 4)  8 1  0 5   2 03660 02660      '/,
     $B( 80)/' 19 P2_12_12_D2 - 4( 4)  8 1  0 5   2 03660 02066      '/
      data
     $B( 81)/' 20 C222_1   D2 - 5( 4)  8 1  0 5   2 03000 02006      '/,
     $B( 82)/' 20 A2_122   D2 - 5( 4)  8 1  0 5   2 03600 02000      '/,
     $B( 83)/' 20 B22_12   D2 - 5( 4)  8 1  0 5   2 03000 02060      '/,
     $B( 84)/' 21 C222     D2 - 6( 4)  8 1  0 5   2 03000 02000      '/,
     $B( 85)/' 21 A222     D2 - 6( 4)  8 1  0 5   2 03000 02000      '/,
     $B( 86)/' 21 B222     D2 - 6( 4)  8 1  0 5   2 03000 02000      '/,
     $B( 87)/' 22 F222     D2 - 7( 4)  8 1  0 5   2 03000 02000      '/,
     $B( 88)/' 23 I222     D2 - 8( 4)  8 1  0 5   2 03000 02000      '/,
     $B( 89)/' 24 I2_12_12_D2 - 9( 4)  8 1  0 5   2 03006 02600      '/,
     $B( 90)/' 25 PMM2     C2V- 1( 4)  6 1  0 5   2 35000 34000      '/,
     $B( 91)/' 25 PM2M     C2V- 1( 4)  6 1  0 5   2 35000 36000      '/,
     $B( 92)/' 25 P2MM     C2V- 1( 4)  6 1  0 5   2 34000 36000      '/,
     $B( 93)/' 26 PMC2_1   C2V- 2( 4)  6 1  0 5   2 35000 34006      '/,
     $B( 94)/' 26 PCM2_1   C2V- 2( 4)  6 1  0 5   2 35006 34000      '/,
     $B( 95)/' 26 PM2_1B   C2V- 2( 4)  6 1  0 5   2 35000 36060      '/,
     $B( 96)/' 26 PB2_1M   C2V- 2( 4)  6 1  0 5   2 35060 36000      '/,
     $B( 97)/' 26 P2_1MA   C2V- 2( 4)  6 1  0 5   2 34000 36600      '/,
     $B( 98)/' 26 P2_1AM   C2V- 2( 4)  6 1  0 5   2 34600 36000      '/,
     $B( 99)/' 27 PCC2     C2V- 3( 4)  6 1  0 5   2 35006 34006      '/,
     $B(100)/' 27 PB2B     C2V- 3( 4)  6 1  0 5   2 35060 36060      '/
      data
     $B(101)/' 27 P2AA     C2V- 3( 4)  6 1  0 5   2 34600 36600      '/,
     $B(102)/' 28 PMA2     C2V- 4( 4)  6 1  0 5   2 35600 34600      '/,
     $B(103)/' 28 PBM2     C2V- 4( 4)  6 1  0 5   2 35060 34060      '/,
     $B(104)/' 28 PM2A     C2V- 4( 4)  6 1  0 5   2 35600 36600      '/,
     $B(105)/' 28 PC2M     C2V- 4( 4)  6 1  0 5   2 35006 36006      '/,
     $B(106)/' 28 P2MB     C2V- 4( 4)  6 1  0 5   2 34060 36060      '/,
     $B(107)/' 28 P2CM     C2V- 4( 4)  6 1  0 5   2 34006 36006      '/,
     $B(108)/' 29 PCA2_1   C2V- 5( 4)  6 1  0 5   2 35606 34600      '/,
     $B(109)/' 29 PBC2_1   C2V- 5( 4)  6 1  0 5   2 35060 34066      '/,
     $B(110)/' 29 PB2_1A   C2V- 5( 4)  6 1  0 5   2 35660 36600      '/,
     $B(111)/' 29 PC2_1B   C2V- 5( 4)  6 1  0 5   2 35006 36066      '/,
     $B(112)/' 29 P2_1AB   C2V- 5( 4)  6 1  0 5   2 34660 36060      '/,
     $B(113)/' 29 P2_1CA   C2V- 5( 4)  6 1  0 5   2 34006 36606      '/,
     $B(114)/' 30 PNC2     C2V- 6( 4)  6 1  0 5   2 35066 34066      '/,
     $B(115)/' 30 PCN2     C2V- 6( 4)  6 1  0 5   2 35606 34606      '/,
     $B(116)/' 30 PN2B     C2V- 6( 4)  6 1  0 5   2 35066 36066      '/,
     $B(117)/' 30 PB2N     C2V- 6( 4)  6 1  0 5   2 35660 36660      '/,
     $B(118)/' 30 P2AN     C2V- 6( 4)  6 1  0 5   2 34660 36660      '/,
     $B(119)/' 30 P2NA     C2V- 6( 4)  6 1  0 5   2 34606 36606      '/,
     $B(120)/' 31 PMN2_1   C2V- 7( 4)  6 1  0 5   2 35000 34606      '/
      data
     $B(121)/' 31 PNM2_1   C2V- 7( 4)  6 1  0 5   2 35066 34000      '/,
     $B(122)/' 31 PN2_1M   C2V- 7( 4)  6 1  0 5   2 35066 36000      '/,
     $B(123)/' 31 PM2_1N   C2V- 7( 4)  6 1  0 5   2 35000 36660      '/,
     $B(124)/' 31 P2_1MN   C2V- 7( 4)  6 1  0 5   2 34000 36660      '/,
     $B(125)/' 31 P2_1NM   C2V- 7( 4)  6 1  0 5   2 34606 36000      '/,
     $B(126)/' 32 PBA2     C2V- 8( 4)  6 1  0 5   2 35660 34660      '/,
     $B(127)/' 32 PC2A     C2V- 8( 4)  6 1  0 5   2 35606 36606      '/,
     $B(128)/' 32 P2CB     C2V- 8( 4)  6 1  0 5   2 34066 36066      '/,
     $B(129)/' 33 PNA2_1   C2V- 9( 4)  6 1  0 5   2 35666 34660      '/,
     $B(130)/' 33 PBN2_1   C2V- 9( 4)  6 1  0 5   2 35660 34666      '/,
     $B(131)/' 33 PC2_1N   C2V- 9( 4)  6 1  0 5   2 35606 36666      '/,
     $B(132)/' 33 PN2_1A   C2V- 9( 4)  6 1  0 5   2 35666 36606      '/,
     $B(133)/' 33 P2_1NB   C2V- 9( 4)  6 1  0 5   2 34666 36066      '/,
     $B(134)/' 33 P2_1CN   C2V- 9( 4)  6 1  0 5   2 34066 36666      '/,
     $B(135)/' 34 PNN2     C2V-10( 4)  6 1  0 5   2 35666 34666      '/,
     $B(136)/' 34 PN2N     C2V-10( 4)  6 1  0 5   2 35666 36666      '/,
     $B(137)/' 34 P2NN     C2V-10( 4)  6 1  0 5   2 34666 36666      '/,
     $B(138)/' 35 CMM2     C2V-11( 4)  6 1  0 5   2 35000 34000      '/,
     $B(139)/' 35 BM2M     C2V-11( 4)  6 1  0 5   2 35000 36000      '/,
     $B(140)/' 35 A2MM     C2V-11( 4)  6 1  0 5   2 34000 36000      '/
      data
     $B(145)/' 36 CMC2_1   C2V-12( 4)  6 1  0 5   2 35000 34006      '/,
     $B(146)/' 36 CCM2_1   C2V-12( 4)  6 1  0 5   2 35006 34000      '/,
     $B(143)/' 36 BB2_1M   C2V-12( 4)  6 1  0 5   2 35060 36000      '/,
     $B(144)/' 36 BM2_1B   C2V-12( 4)  6 1  0 5   2 35000 36060      '/,
     $B(141)/' 36 A2_1MA   C2V-12( 4)  6 1  0 5   2 34000 36600      '/,
     $B(142)/' 36 A2_1AM   C2V-12( 4)  6 1  0 5   2 34600 36000      '/,
     $B(147)/' 37 CCC2     C2V-13( 4)  6 1  0 5   2 35006 34006      '/,
     $B(148)/' 37 BB2B     C2V-13( 4)  6 1  0 5   2 35060 36060      '/,
     $B(149)/' 37 A2AA     C2V-13( 4)  6 1  0 5   2 34600 36600      '/,
     $B(150)/' 38 AMM2     C2V-14( 4)  6 1  0 5   2 35000 34000      '/,
     $B(151)/' 38 BMM2     C2V-14( 4)  6 1  0 5   2 35000 34000      '/,
     $B(152)/' 38 AM2M     C2V-14( 4)  6 1  0 5   2 35000 36000      '/,
     $B(153)/' 38 CM2M     C2V-14( 4)  6 1  0 5   2 35000 36000      '/,
     $B(154)/' 38 B2MM     C2V-14( 4)  6 1  0 5   2 34000 36000      '/,
     $B(155)/' 38 C2MM     C2V-14( 4)  6 1  0 5   2 34000 36000      '/,
     $B(156)/' 39 ABM2     C2V-15( 4)  6 1  0 5   2 35060 34060      '/,
     $B(157)/' 39 BMA2     C2V-15( 4)  6 1  0 5   2 35600 34600      '/,
     $B(158)/' 39 CM2A     C2V-15( 4)  6 1  0 5   2 35600 36600      '/,
     $B(159)/' 39 AC2M     C2V-15( 4)  6 1  0 5   2 35060 36060      '/,
     $B(160)/' 39 B2CM     C2V-15( 4)  6 1  0 5   2 34600 36600      '/
      data
     $B(161)/' 39 C2MB     C2V-15( 4)  6 1  0 5   2 34600 36600      '/,
     $B(162)/' 40 AMA2     C2V-16( 4)  6 1  0 5   2 35600 34600      '/,
     $B(163)/' 40 BBM2     C2V-16( 4)  6 1  0 5   2 35060 34060      '/,
     $B(164)/' 40 CC2M     C2V-16( 4)  6 1  0 5   2 35006 36006      '/,
     $B(165)/' 40 AM2A     C2V-16( 4)  6 1  0 5   2 35600 36600      '/,
     $B(166)/' 40 B2MB     C2V-16( 4)  6 1  0 5   2 34060 36060      '/,
     $B(167)/' 40 C2CM     C2V-16( 4)  6 1  0 5   2 34006 36006      '/,
     $B(168)/' 41 ABA2     C2V-17( 4)  6 1  0 5   2 35660 34660      '/,
     $B(169)/' 41 BBA2     C2V-17( 4)  6 1  0 5   2 35660 34660      '/,
     $B(170)/' 41 CC2A     C2V-17( 4)  6 1  0 5   2 35606 36606      '/,
     $B(171)/' 41 AC2A     C2V-17( 4)  6 1  0 5   2 35660 36660      '/,
     $B(172)/' 41 B2CB     C2V-17( 4)  6 1  0 5   2 34660 36660      '/,
     $B(173)/' 41 C2CB     C2V-17( 4)  6 1  0 5   2 34606 36606      '/,
     $B(174)/' 42 FMM2     C2V-18( 4)  6 1  0 5   2 35000 34000      '/,
     $B(175)/' 42 FM2M     C2V-18( 4)  6 1  0 5   2 35000 36000      '/,
     $B(176)/' 42 F2MM     C2V-18( 4)  6 1  0 5   2 34000 36000      '/,
     $B(177)/' 43 FDD2     C2V-19( 4)  6 1  0 5   2 35333 34333      '/,
     $B(178)/' 43 FD2D     C2V-19( 4)  6 1  0 5   2 35333 36333      '/,
     $B(179)/' 43 F2DD     C2V-19( 4)  6 1  0 5   2 34333 36333      '/,
     $B(180)/' 44 IMM2     C2V-20( 4)  6 1  0 5   2 35000 34000      '/
      data
     $B(181)/' 44 IM2M     C2V-20( 4)  6 1  0 5   2 35000 36000      '/,
     $B(182)/' 44 I2MM     C2V-20( 4)  6 1  0 5   2 34000 36000      '/,
     $B(183)/' 45 IBA2     C2V-21( 4)  6 1  0 5   2 35006 34006      '/,
     $B(184)/' 45 IC2A     C2V-21( 4)  6 1  0 5   2 35060 36060      '/,
     $B(185)/' 45 I2CB     C2V-21( 4)  6 1  0 5   2 34600 36600      '/,
     $B(186)/' 46 IMA2     C2V-22( 4)  6 1  0 5   2 35600 34600      '/,
     $B(187)/' 46 IBM2     C2V-22( 4)  6 1  0 5   2 35060 34060      '/,
     $B(188)/' 46 IC2M     C2V-22( 4)  6 1  0 5   2 35006 36006      '/,
     $B(189)/' 46 IM2A     C2V-22( 4)  6 1  0 5   2 35600 36600      '/,
     $B(190)/' 46 I2MB     C2V-22( 4)  6 1  0 5   2 34060 36060      '/,
     $B(191)/' 46 I2CM     C2V-22( 4)  6 1  0 5   2 34006 36006      '/,
     $B(192)/' 47 PMMM     D2H- 1( 8)  7 0  0 5   3 33000 35000 34000'/,
     $B(193)/' 48*PNNN     D2H- 2( 8)  7 0  0 5   3 33666 35666 34666'/,
     $B(194)/' 48+PNNN     D2H- 2( 8)  7 0  0 5   3 33000 35066 34606'/,
     $B(195)/' 49 PCCM     D2H- 3( 8)  7 0  0 5   3 33000 35006 34006'/,
     $B(196)/' 49 PMAA     D2H- 3( 8)  7 0  0 5   3 33000 35000 34600'/,
     $B(197)/' 49 PBMB     D2H- 3( 8)  7 0  0 5   3 33000 35060 34000'/,
     $B(198)/' 50*PBAN     D2H- 4( 8)  7 0  0 5   3 33660 35660 34660'/,
     $B(199)/' 50+PBAN     D2H- 4( 8)  7 0  0 5   3 33000 35060 34600'/,
     $B(200)/' 50*PNCB     D2H- 4( 8)  7 0  0 5   3 33066 35066 34066'/
      data
     $B(201)/' 50+PNCB     D2H- 4( 8)  7 0  0 5   3 33000 35066 34006'/,
     $B(202)/' 50*PCNA     D2H- 4( 8)  7 0  0 5   3 33606 35606 34606'/,
     $B(203)/' 50+PCNA     D2H- 4( 8)  7 0  0 5   3 33000 35006 34606'/,
     $B(204)/' 51 PMMA     D2H- 5( 8)  7 0  0 5   3 33000 35600 34000'/,
     $B(205)/' 51 PMMB     D2H- 5( 8)  7 0  0 5   3 33000 35000 34060'/,
     $B(206)/' 51 PBMM     D2H- 5( 8)  7 0  0 5   3 33000 35060 34060'/,
     $B(207)/' 51 PCMM     D2H- 5( 8)  7 0  0 5   3 33000 35006 34000'/,
     $B(208)/' 51 PMCM     D2H- 5( 8)  7 0  0 5   3 33000 35000 34006'/,
     $B(209)/' 51 PMAM     D2H- 5( 8)  7 0  0 5   3 33000 35600 34600'/,
     $B(210)/' 52 PNNA     D2H- 6( 8)  7 0  0 5   3 33000 35066 34666'/,
     $B(211)/' 52 PNNB     D2H- 6( 8)  7 0  0 5   3 33000 35666 34606'/,
     $B(212)/' 52 PBNN     D2H- 6( 8)  7 0  0 5   3 33000 35060 34606'/,
     $B(213)/' 52 PCNN     D2H- 6( 8)  7 0  0 5   3 33000 35006 34666'/,
     $B(214)/' 52 PNCN     D2H- 6( 8)  7 0  0 5   3 33000 35666 34006'/,
     $B(215)/' 52 PNAN     D2H- 6( 8)  7 0  0 5   3 33000 35066 34600'/,
     $B(216)/' 53 PMNA     D2H- 7( 8)  7 0  0 5   3 33000 35000 34606'/,
     $B(217)/' 53 PNMB     D2H- 7( 8)  7 0  0 5   3 33000 35066 34000'/,
     $B(218)/' 53 PBMN     D2H- 7( 8)  7 0  0 5   3 33000 35660 34000'/,
     $B(219)/' 53 PCNM     D2H- 7( 8)  7 0  0 5   3 33000 35606 34606'/,
     $B(220)/' 53 PNCM     D2H- 7( 8)  7 0  0 5   3 33000 35066 34066'/
      data
     $B(221)/' 53 PMAN     D2H- 7( 8)  7 0  0 5   3 33000 35000 34660'/,
     $B(222)/' 54 PCCA     D2H- 8( 8)  7 0  0 5   3 33000 35606 34006'/,
     $B(223)/' 54 PCCB     D2H- 8( 8)  7 0  0 5   3 33000 35006 34066'/,
     $B(224)/' 54 PBAA     D2H- 8( 8)  7 0  0 5   3 33000 35060 34660'/,
     $B(225)/' 54 PCAA     D2H- 8( 8)  7 0  0 5   3 33000 35006 34600'/,
     $B(226)/' 54 PBCB     D2H- 8( 8)  7 0  0 5   3 33000 35060 34006'/,
     $B(227)/' 54 PBAB     D2H- 8( 8)  7 0  0 5   3 33000 35660 34600'/,
     $B(228)/' 55 PBAM     D2H- 9( 8)  7 0  0 5   3 33000 35660 34660'/,
     $B(229)/' 55 PMCB     D2H- 9( 8)  7 0  0 5   3 33000 35000 34066'/,
     $B(230)/' 55 PCMA     D2H- 9( 8)  7 0  0 5   3 33000 35606 34000'/,
     $B(231)/' 56 PCCN     D2H-10( 8)  7 0  0 5   3 33000 35606 34066'/,
     $B(232)/' 56 PNAA     D2H-10( 8)  7 0  0 5   3 33000 35066 34660'/,
     $B(233)/' 56 PBNB     D2H-10( 8)  7 0  0 5   3 33000 35660 34606'/,
     $B(234)/' 57 PBCM     D2H-11( 8)  7 0  0 5   3 33000 35060 34066'/,
     $B(235)/' 57 PCAM     D2H-11( 8)  7 0  0 5   3 33000 35606 34600'/,
     $B(236)/' 57 PMCA     D2H-11( 8)  7 0  0 5   3 33000 35600 34006'/,
     $B(237)/' 57 PMAB     D2H-11( 8)  7 0  0 5   3 33000 35600 34660'/,
     $B(238)/' 57 PBMA     D2H-11( 8)  7 0  0 5   3 33000 35660 34060'/,
     $B(239)/' 57 PCMB     D2H-11( 8)  7 0  0 5   3 33000 35006 34060'/,
     $B(240)/' 58 PNNM     D2H-12( 8)  7 0  0 5   3 33000 35666 34666'/
      data
     $B(241)/' 58 PMNN     D2H-12( 8)  7 0  0 5   3 33000 35000 34666'/,
     $B(242)/' 58 PNMN     D2H-12( 8)  7 0  0 5   3 33000 35666 34000'/,
     $B(247)/' 59*PMMN     D2H-13( 8)  7 0  0 5   3 33660 35000 34000'/,
     $B(248)/' 59+PMMN     D2H-13( 8)  7 0  0 5   3 33000 35600 34060'/,
     $B(245)/' 59*PMNM     D2H-13( 8)  7 0  0 5   3 33606 35000 34606'/,
     $B(246)/' 59+PMNM     D2H-13( 8)  7 0  0 5   3 33000 35600 34606'/,
     $B(243)/' 59*PNMM     D2H-13( 8)  7 0  0 5   3 33066 35066 34000'/,
     $B(244)/' 59+PNMM     D2H-13( 8)  7 0  0 5   3 33000 35066 34060'/,
     $B(249)/' 60 PBCN     D2H-14( 8)  7 0  0 5   3 33000 35660 34006'/,
     $B(250)/' 60 PCAN     D2H-14( 8)  7 0  0 5   3 33000 35006 34660'/,
     $B(251)/' 60 PNCA     D2H-14( 8)  7 0  0 5   3 33000 35666 34066'/,
     $B(252)/' 60 PNAB     D2H-14( 8)  7 0  0 5   3 33000 35666 34600'/,
     $B(253)/' 60 PBNA     D2H-14( 8)  7 0  0 5   3 33000 35060 34666'/,
     $B(254)/' 60 PCNB     D2H-14( 8)  7 0  0 5   3 33000 35606 34666'/,
     $B(255)/' 61 PBCA     D2H-15( 8)  7 0  0 5   3 33000 35660 34066'/,
     $B(256)/' 61 PCAB     D2H-15( 8)  7 0  0 5   3 33000 35606 34660'/,
     $B(257)/' 62 PNMA     D2H-16( 8)  7 0  0 5   3 33000 35666 34060'/,
     $B(258)/' 62 PMNB     D2H-16( 8)  7 0  0 5   3 33000 35600 34666'/,
     $B(259)/' 62 PBNM     D2H-16( 8)  7 0  0 5   3 33000 35660 34666'/,
     $B(260)/' 62 PCMN     D2H-16( 8)  7 0  0 5   3 33000 35606 34060'/
      data
     $B(261)/' 62 PMCN     D2H-16( 8)  7 0  0 5   3 33000 35600 34066'/,
     $B(262)/' 62 PNAM     D2H-16( 8)  7 0  0 5   3 33000 35666 34660'/,
     $B(263)/' 63 CMCM     D2H-17( 8)  7 0  0 5   3 33000 35000 34006'/,
     $B(264)/' 63 CCMM     D2H-17( 8)  7 0  0 5   3 33000 35006 34000'/,
     $B(265)/' 63 AMMA     D2H-17( 8)  7 0  0 5   3 33000 35600 34000'/,
     $B(266)/' 63 AMAM     D2H-17( 8)  7 0  0 5   3 33000 35600 34600'/,
     $B(267)/' 63 BBMM     D2H-17( 8)  7 0  0 5   3 33000 35060 34060'/,
     $B(268)/' 63 BMMB     D2H-17( 8)  7 0  0 5   3 33000 35000 34060'/,
     $B(269)/' 64 CMCA     D2H-18( 8)  7 0  0 5   3 33000 35000 34606'/,
     $B(270)/' 64 CCMB     D2H-18( 8)  7 0  0 5   3 33000 35606 34000'/,
     $B(271)/' 64 ABMA     D2H-18( 8)  7 0  0 5   3 33000 35660 34000'/,
     $B(272)/' 64 ACAM     D2H-18( 8)  7 0  0 5   3 33000 35660 34660'/,
     $B(273)/' 64 BBCM     D2H-18( 8)  7 0  0 5   3 33000 35660 34660'/,
     $B(274)/' 64 BMAB     D2H-18( 8)  7 0  0 5   3 33000 35000 34660'/,
     $B(275)/' 65 CMMM     D2H-19( 8)  7 0  0 5   3 33000 35000 34000'/,
     $B(276)/' 65 AMMM     D2H-19( 8)  7 0  0 5   3 33000 35000 34000'/,
     $B(277)/' 65 BMMM     D2H-19( 8)  7 0  0 5   3 33000 35000 34000'/,
     $B(278)/' 66 CCCM     D2H-20( 8)  7 0  0 5   3 33000 35006 34006'/,
     $B(279)/' 66 AMAA     D2H-20( 8)  7 0  0 5   3 33000 35000 34600'/,
     $B(280)/' 66 BBMB     D2H-20( 8)  7 0  0 5   3 33000 35060 34000'/
      data
     $B(281)/' 67 CMMA     D2H-21( 8)  7 0  0 5   3 33000 35000 34600'/,
     $B(282)/' 67 CMMB     D2H-21( 8)  7 0  0 5   3 33000 35600 34000'/,
     $B(283)/' 67 ABMM     D2H-21( 8)  7 0  0 5   3 33000 35060 34000'/,
     $B(284)/' 67 ACMM     D2H-21( 8)  7 0  0 5   3 33000 35060 34060'/,
     $B(285)/' 67 BMCM     D2H-21( 8)  7 0  0 5   3 33000 35600 34600'/,
     $B(286)/' 67 BMAM     D2H-21( 8)  7 0  0 5   3 33000 35000 34600'/,
     $B(287)/' 68*CCCA     D2H-22( 8)  7 0  0 5   3 33606 35606 34606'/,
     $B(288)/' 68+CCCA     D2H-22( 8)  7 0  0 5   3 33000 35606 34006'/,
     $B(289)/' 68*CCCB     D2H-22( 8)  7 0  0 5   3 33606 35606 34606'/,
     $B(290)/' 68+CCCB     D2H-22( 8)  7 0  0 5   3 33000 35006 34606'/,
     $B(291)/' 68*ABAA     D2H-22( 8)  7 0  0 5   3 33660 35660 34660'/,
     $B(292)/' 68+ABAA     D2H-22( 8)  7 0  0 5   3 33000 35060 34660'/,
     $B(293)/' 68*ACAA     D2H-22( 8)  7 0  0 5   3 33660 35660 34660'/,
     $B(294)/' 68+ACAA     D2H-22( 8)  7 0  0 5   3 33000 35060 34600'/,
     $B(295)/' 68*BBCB     D2H-22( 8)  7 0  0 5   3 33660 35660 34660'/,
     $B(296)/' 68+BBCB     D2H-22( 8)  7 0  0 5   3 33000 35060 34600'/,
     $B(297)/' 68*BBAB     D2H-22( 8)  7 0  0 5   3 33660 35660 34660'/,
     $B(298)/' 68+BBAB     D2H-22( 8)  7 0  0 5   3 33000 35660 34600'/,
     $B(299)/' 69 FMMM     D2H-23( 8)  7 0  0 5   3 33000 35000 34000'/,
     $B(300)/' 70*FDDD     D2H-24( 8)  7 0  0 5   3 33333 35333 34333'/
      data
     $B(301)/' 70+FDDD     D2H-24( 8)  7 0  0 5   3 33000 35033 34303'/,
     $B(302)/' 71 IMMM     D2H-25( 8)  7 0  0 5   3 33000 35000 34000'/,
     $B(303)/' 72 IBAM     D2H-26( 8)  7 0  0 5   3 33000 35006 34006'/,
     $B(304)/' 72 IMCB     D2H-26( 8)  7 0  0 5   3 33000 35000 34600'/,
     $B(305)/' 72 ICMA     D2H-26( 8)  7 0  0 5   3 33000 35060 34000'/,
     $B(306)/' 73 IBCA     D2H-27( 8)  7 0  0 5   3 33000 35006 34600'/,
     $B(307)/' 73 ICAB     D2H-27( 8)  7 0  0 5   3 33000 35060 34006'/,
     $B(308)/' 74 IMMA     D2H-28( 8)  7 0  0 5   3 33000 35000 34060'/,
     $B(309)/' 74 IMMB     D2H-28( 8)  7 0  0 5   3 33000 35600 34000'/,
     $B(310)/' 74 IBMM     D2H-28( 8)  7 0  0 5   3 33000 35006 34000'/,
     $B(311)/' 74 ICMM     D2H-28( 8)  7 0  0 5   3 33000 35060 34060'/,
     $B(312)/' 74 IMCM     D2H-28( 8)  7 0  0 5   3 33000 35600 34600'/,
     $B(313)/' 74 IMAM     D2H-28( 8)  7 0  0 5   3 33000 35000 34006'/,
     $B(314)/' 75 P4       C4 - 1( 4) 10 1 48 3   1 15000            '/,
     $B(315)/' 76 P4_1     C4 - 2( 4) 10 1 48 3   1 15003            '/,
     $B(316)/' 77 P4_2     C4 - 3( 4) 10 1 48 3   1 15006            '/,
     $B(317)/' 78 P4_3     C4 - 4( 4) 10 1 48 3   1 15009            '/,
     $B(318)/' 79 I4       C4 - 5( 4) 10 1 48 3   1 15000            '/,
     $B(319)/' 80 I4_1     C4 - 6( 4) 10 1 48 3   1 15609            '/,
     $B(320)/' 81 P-4      S4 - 1( 4)  9 1 48 3   1 47000            '/
      data
     $B(321)/' 82 I-4      S4 - 2( 4)  9 1 48 3   1 47000            '/,
     $B(322)/' 83 P4/M     C4H- 1( 8) 11 0 48 3   2 33000 15000      '/,
     $B(323)/' 84 P4_2/M   C4H- 2( 8) 11 0 48 3   2 33000 15006      '/,
     $B(324)/' 85*P4/N     C4H- 3( 8) 11 0 48 3   2 33660 15660      '/,
     $B(325)/' 85+P4/N     C4H- 3( 8) 11 0 48 3   2 33000 15600      '/,
     $B(326)/' 86*P4_2/N   C4H- 4( 8) 11 0 48 3   2 33666 15666      '/,
     $B(327)/' 86+P4_2/N   C4H- 4( 8) 11 0 48 3   2 33000 15066      '/,
     $B(328)/' 87 I4/M     C4H- 5( 8) 11 0 48 3   2 33000 15000      '/,
     $B(329)/' 88*I4_1/A   C4H- 6( 8) 11 0 48 3   2 33609 15609      '/,
     $B(330)/' 88+I4_1/A   C4H- 6( 8) 11 0 48 3   2 33000 15933      '/,
     $B(331)/' 89 P422     D4 - 1( 8) 14 1  0 3   2 15000 03000      '/,
     $B(332)/' 90 P42_12   D4 - 2( 8) 14 1  0 3   2 15660 03660      '/,
     $B(333)/' 91 P4_122   D4 - 3( 8) 14 1  0 3   2 15003 03006      '/,
     $B(334)/' 92 P4_12_12 D4 - 4( 8) 14 1  0 3   2 15663 03669      '/,
     $B(335)/' 93 P4_222   D4 - 5( 8) 14 1  0 3   2 15006 03000      '/,
     $B(336)/' 94 P4_22_12 D4 - 6( 8) 14 1  0 3   2 15666 03666      '/,
     $B(337)/' 95 P4_322   D4 - 7( 8) 14 1  0 3   2 15009 03006      '/,
     $B(338)/' 96 P4_32_12 D4 - 8( 8) 14 1  0 3   2 15669 03663      '/,
     $B(339)/' 97 I422     D4 - 9( 8) 14 1  0 3   2 15000 03000      '/,
     $B(340)/' 98 I4_122   D4 -10( 8) 14 1  0 3   2 15609 03609      '/
      data
     $B(341)/' 99 P4MM     C4V- 1( 8) 13 1  0 3   2 15000 35000      '/,
     $B(342)/'100 P4BM     C4V- 2( 8) 13 1  0 3   2 15000 35660      '/,
     $B(343)/'101 P4_2CM   C4V- 3( 8) 13 1  0 3   2 15006 35006      '/,
     $B(344)/'102 P4_2NM   C4V- 4( 8) 13 1  0 3   2 15666 35666      '/,
     $B(345)/'103 P4CC     C4V- 5( 8) 13 1  0 3   2 15000 35006      '/,
     $B(346)/'104 P4NC     C4V- 6( 8) 13 1  0 3   2 15000 35666      '/,
     $B(347)/'105 P4_2MC   C4V- 7( 8) 13 1  0 3   2 15006 35000      '/,
     $B(348)/'106 P4_2BC   C4V- 8( 8) 13 1  0 3   2 15006 35660      '/,
     $B(349)/'107 I4MM     C4V- 9( 8) 13 1  0 3   2 15000 35000      '/,
     $B(350)/'108 I4CM     C4V-10( 8) 13 1  0 3   2 15000 35006      '/,
     $B(351)/'109 I4_1MD   C4V-11( 8) 13 1  0 3   2 15609 35000      '/,
     $B(352)/'110 I4_1CD   C4V-12( 8) 13 1  0 3   2 15609 35006      '/,
     $B(353)/'111 P-42M    D2D- 1( 8) 36 1  0 3   2 47000 03000      '/,
     $B(354)/'112 P-42C    D2D- 2( 8) 36 1  0 3   2 47000 03006      '/,
     $B(355)/'113 P-42_1M  D2D- 3( 8) 36 1  0 3   2 47000 03660      '/,
     $B(356)/'114 P-42_1C  D2D- 4( 8) 36 1  0 3   2 47000 03666      '/,
     $B(357)/'115 P-4M2    D2D- 5( 8) 12 1  0 3   2 47000 35000      '/,
     $B(358)/'116 P-4C2    D2D- 6( 8) 12 1  0 3   2 47000 35006      '/,
     $B(359)/'117 P-4B2    D2D- 7( 8) 12 1  0 3   2 47000 35660      '/,
     $B(360)/'118 P-4N2    D2D- 8( 8) 12 1  0 3   2 47000 35666      '/
      data
     $B(361)/'119 I-4M2    D2D- 9( 8) 12 1  0 3   2 47000 35000      '/,
     $B(362)/'120 I-4C2    D2D-10( 8) 12 1  0 3   2 47000 35006      '/,
     $B(363)/'121 I-42M    D2D-11( 8) 36 1  0 3   2 47000 03000      '/,
     $B(364)/'122 I-42D    D2D-12( 8) 36 1  0 3   2 47000 03609      '/,
     $B(365)/'123 P4/MMM   D4H- 1(16) 15 0  0 3   3 33000 15000 35000'/,
     $B(366)/'124 P4/MCC   D4H- 2(16) 15 0  0 3   3 33000 15000 35006'/,
     $B(367)/'125*P4/NBM   D4H- 3(16) 15 0  0 3   3 33660 15000 35660'/,
     $B(368)/'125+P4/NBM   D4H- 3(16) 15 0  0 3   3 33000 15600 35060'/,
     $B(369)/'126*P4/NNC   D4H- 4(16) 15 0  0 3   3 33666 15000 35666'/,
     $B(370)/'126+P4/NNC   D4H- 4(16) 15 0  0 3   3 33000 15600 35066'/,
     $B(371)/'127 P4/MBM   D4H- 5(16) 15 0  0 3   3 33000 15000 35660'/,
     $B(372)/'128 P4/MNC   D4H- 6(16) 15 0  0 3   3 33000 15000 35666'/,
     $B(373)/'129*P4/NMM   D4H- 7(16) 15 0  0 3   3 33660 15660 35000'/,
     $B(374)/'129+P4/NMM   D4H- 7(16) 15 0  0 3   3 33000 15600 35600'/,
     $B(375)/'130*P4/NCC   D4H- 8(16) 15 0  0 3   3 33660 15660 35006'/,
     $B(376)/'130+P4/NCC   D4H- 8(16) 15 0  0 3   3 33000 15600 35606'/,
     $B(377)/'131 P4_2/MMC D4H- 9(16) 15 0  0 3   3 33000 15006 35000'/,
     $B(378)/'132 P4_2/MCM D4H-10(16) 15 0  0 3   3 33000 15006 35006'/,
     $B(379)/'133*P4_2/NBC D4H-11(16) 15 0  0 3   3 33666 15666 35660'/,
     $B(380)/'133+P4_2/NBC D4H-11(16) 15 0  0 3   3 33000 15606 35060'/
      data
     $B(381)/'134*P4_2/NNM D4H-12(16) 15 0  0 3   3 33666 15666 35666'/,
     $B(382)/'134+P4_2/NNM D4H-12(16) 15 0  0 3   3 33000 15606 35066'/,
     $B(383)/'135 P4_2/MBC D4H-13(16) 15 0  0 3   3 33000 15006 35660'/,
     $B(384)/'136 P4_2/MNM D4H-14(16) 15 0  0 3   3 33000 15666 35666'/,
     $B(385)/'137*P4_2/NMC D4H-15(16) 15 0  0 3   3 33666 15666 35000'/,
     $B(386)/'137+P4_2/NMC D4H-15(16) 15 0  0 3   3 33000 15606 35600'/,
     $B(387)/'138*P4_2/NCM D4H-16(16) 15 0  0 3   3 33666 15666 35006'/,
     $B(388)/'138+P4_2/NCM D4H-16(16) 15 0  0 3   3 33000 15606 35606'/,
     $B(389)/'139 I4/MMM   D4H-17(16) 15 0  0 3   3 33000 15000 35000'/,
     $B(390)/'140 I4/MCM   D4H-18(16) 15 0  0 3   3 33000 15000 35006'/,
     $B(391)/'141*I4_1/AMD D4H-19(16) 15 0  0 3   3 33609 15609 35000'/,
     $B(392)/'141+I4_1/AMD D4H-19(16) 15 0  0 3   3 33000 15393 35000'/,
     $B(393)/'142*I4_1/ACD D4H-20(16) 15 0  0 3   3 33609 15609 35006'/,
     $B(394)/'142+I4_1/ACD D4H-20(16) 15 0  0 3   3 33000 15393 35006'/,
     $B(395)/'143 P3       C3 - 1( 3) 28 1 34 4   1 27000            '/,
     $B(396)/'143 P311     C3 - 1( 3) 28 1 34 4   1 27000            '/,
     $B(397)/'144 P3_1     C3 - 2( 3) 28 1 34 4   1 27004            '/,
     $B(398)/'144 P3_111   C3 - 2( 3) 28 1 34 4   1 27004            '/,
     $B(399)/'145 P3_2     C3 - 3( 3) 28 1 34 4   1 27008            '/,
     $B(400)/'145 P3_211   C3 - 3( 3) 28 1 34 4   1 27008            '/
      data
     $B(402)/'146 R3       C3 - 4( 3) 28 1 34 4   1 27000            '/,
     $B(401)/'146 P31      C3 - 4( 3) 28 1 34-4   1 27000            '/,
     $B(403)/'147 P-3      C3I- 1( 6) 29 0 34 4   2 33000 27000      '/,
     $B(404)/'147 P-311    C3I- 1( 6) 29 0 34 4   2 33000 27000      '/,
     $B(406)/'148 R-3      C3I- 2( 6) 29 0 34 4   2 33000 27000      '/,
     $B(405)/'148 P-31     C3I- 2( 6) 29 0 34-4   2 33000 27000      '/,
     $B(407)/'149 P312     D3 - 1( 6) 37 1  0 4   2 27000 03000      '/,
     $B(408)/'150 P321     D3 - 2( 6) 30 1  0 4   2 27000 02000      '/,
     $B(409)/'151 P3_112   D3 - 3( 6) 37 1  0 4   2 27004 03000      '/,
     $B(410)/'152 P3_121   D3 - 4( 6) 30 1  0 4   2 27004 02004      '/,
     $B(411)/'153 P3_212   D3 - 5( 6) 37 1  0 4   2 27008 03000      '/,
     $B(412)/'154 P3_221   D3 - 6( 6) 30 1  0 4   2 27008 02008      '/,
     $B(414)/'155 R32      D3 - 7( 6) 30 1  0 4   2 27000 02000      '/,
     $B(413)/'155 P32      D3 - 7( 6) 30 1  0-4   2 27000 02000      '/,
     $B(415)/'156 P3M1     C3V- 1( 6) 31 1  0 4   2 27000 34000      '/,
     $B(416)/'157 P31M     C3V- 2( 6) 38 1  0 4   2 27000 35000      '/,
     $B(417)/'158 P3C1     C3V- 3( 6) 31 1  0 4   2 27000 34006      '/,
     $B(418)/'159 P31C     C3V- 4( 6) 38 1  0 4   2 27000 35006      '/,
     $B(420)/'160 R3M      C3V- 5( 6) 31 1  0 4   2 27000 34000      '/,
     $B(419)/'160 P3M      C3V- 5( 6) 31 1  0-4   2 27000 34000      '/
      data
     $B(422)/'161 R3C      C3V- 6( 6) 31 1  0 4   2 27000 34006      '/,
     $B(421)/'161 P3C      C3V- 6( 6) 31 1  0-4   2 27000 34666      '/,
     $B(423)/'162 P-31M    D3D- 1(12) 39 0  0 4   3 33000 27000 35000'/,
     $B(424)/'163 P-31C    D3D- 2(12) 39 0  0 4   3 33000 27000 35006'/,
     $B(425)/'164 P-3M1    D3D- 3(12) 32 0  0 4   3 33000 27000 34000'/,
     $B(426)/'165 P-3C1    D3D- 4(12) 32 0  0 4   3 33000 27000 34006'/,
     $B(428)/'166 R-3M     D3D- 5(12) 32 0  0 4   3 33000 27000 34000'/,
     $B(427)/'166 P-3M     D3D- 5(12) 32 0  0-4   3 33000 27000 34000'/,
     $B(430)/'167 R-3C     D3D- 6(12) 32 0  0 4   3 33000 27000 34006'/,
     $B(429)/'167 P-3C     D3D- 6(12) 32 0  0-4   3 33000 27000 34666'/,
     $B(431)/'168 P6       C6 - 1( 6) 21 1 34 2   1 28000            '/,
     $B(432)/'169 P6_1     C6 - 2( 6) 21 1 34 2   1 28002            '/,
     $B(433)/'170 P6_5     C6 - 3( 6) 21 1 34 2   1 28010            '/,
     $B(434)/'171 P6_2     C6 - 4( 6) 21 1 34 2   1 28004            '/,
     $B(435)/'172 P6_4     C6 - 5( 6) 21 1 34 2   1 28008            '/,
     $B(436)/'173 P6_3     C6 - 6( 6) 21 1 34 2   1 28006            '/,
     $B(437)/'174 P-6      C3H- 1( 6) 40 1 34 2   1 60000            '/,
     $B(438)/'175 P6/M     C6H- 1(12) 23 0 34 2   2 33000 28000      '/,
     $B(439)/'176 P6_3/M   C6H- 2(12) 23 0 34 2   2 33000 28006      '/,
     $B(440)/'177 P622     D6 - 1(12) 24 1  0 2   2 28000 03000      '/
      data
     $B(441)/'178 P6_122   D6 - 2(12) 24 1  0 2   2 28002 03002      '/,
     $B(442)/'179 P6_522   D6 - 3(12) 24 1  0 2   2 25002 02004      '/,
     $B(443)/'180 P6_222   D6 - 4(12) 24 1  0 2   2 28004 03004      '/,
     $B(444)/'181 P6_422   D6 - 5(12) 24 1  0 2   2 28008 03008      '/,
     $B(445)/'182 P6_322   D6 - 6(12) 24 1  0 2   2 28006 03006      '/,
     $B(446)/'183 P6MM     C6V- 1(12) 25 1  0 2   2 28000 35000      '/,
     $B(447)/'184 P6CC     C6V- 2(12) 25 1  0 2   2 28000 35006      '/,
     $B(448)/'185 P6_3CM   C6V- 3(12) 25 1  0 2   2 28006 35000      '/,
     $B(449)/'186 P6_3MC   C6V- 4(12) 25 1  0 2   2 28006 35006      '/,
     $B(450)/'187 P-6M2    D3H- 1(12) 27 1  0 2   2 60000 34000      '/,
     $B(451)/'188 P-6C2    D3H- 2(12) 27 1  0 2   2 60006 34006      '/,
     $B(452)/'189 P-62M    D3H- 3(12) 33 1  0 2   2 60000 35000      '/,
     $B(453)/'190 P-62C    D3H- 4(12) 33 1  0 2   2 60006 35006      '/,
     $B(454)/'191 P6/MMM   D6H- 1(24) 26 0  0 2   3 33000 28000 35000'/,
     $B(455)/'192 P6/MCC   D6H- 2(24) 26 0  0 2   3 33000 28000 35006'/,
     $B(456)/'193 P6_3/MCM D6H- 3(24) 26 0  0 2   3 33000 28006 35000'/,
     $B(457)/'194 P6_3/MMC D6H- 4(24) 26 0  0 2   3 33000 28006 35006'/,
     $B(458)/'195 P23      T  - 1(12) 16 1 48 1   2 10000 03000      '/,
     $B(459)/'196 F23      T  - 2(12) 16 1 48 1   2 10000 03000      '/,
     $B(460)/'197 I23      T  - 3(12) 16 1 48 1   2 10000 03000      '/
      data
     $B(461)/'198 P2_13    T  - 4(12) 16 1 48 1   2 10000 03660      '/,
     $B(462)/'199 I2_13    T  - 5(12) 16 1 48 1   2 10000 03006      '/,
     $B(463)/'200 PM-3     TH - 1(24) 17 0 48 1   3 33000 10000 35000'/,
     $B(464)/'201*PN-3     TH - 2(24) 17 0 48 1   3 33666 10000 35666'/,
     $B(465)/'201+PN-3     TH - 2(24) 17 0 48 1   3 33000 10000 35066'/,
     $B(466)/'202 FM-3     TH - 3(24) 17 0 48 1   3 33000 10000 35000'/,
     $B(467)/'203*FD-3     TH - 4(24) 17 0 48 1   3 33333 10000 35333'/,
     $B(468)/'203+FD-3     TH - 4(24) 17 0 48 1   3 33000 10000 35033'/,
     $B(469)/'204 IM-3     TH - 5(24) 17 0 48 1   3 33000 10000 35000'/,
     $B(470)/'205 PA-3     TH - 6(24) 17 0 48 1   3 33000 10000 35660'/,
     $B(471)/'206 IA-3     TH - 7(24) 17 0 48 1   3 33000 10000 35006'/,
     $B(472)/'207 P432     O  - 1(24) 18 1  0 1   2 24000 10000      '/,
     $B(473)/'208 P4_232   O  - 2(24) 18 1  0 1   2 24666 10000      '/,
     $B(474)/'209 F432     O  - 3(24) 18 1  0 1   2 24000 10000      '/,
     $B(475)/'210 F4_132   O  - 4(24) 18 1  0 1   2 24333 10000      '/,
     $B(476)/'211 I432     O  - 5(24) 18 1  0 1   2 24000 10000      '/,
     $B(477)/'212 P4_332   O  - 6(24) 18 1  0 1   2 24993 10000      '/,
     $B(478)/'213 P4_132   O  - 7(24) 18 1  0 1   2 24339 10000      '/,
     $B(479)/'214 I4_132   O  - 8(24) 18 1  0 1   2 24339 10000      '/,
     $B(480)/'215 P-43M    TD - 1(24) 19 1  0 1   2 56000 10000      '/
      data
     $B(481)/'216 F-43M    TD - 2(24) 19 1  0 1   2 56000 10000      '/,
     $B(482)/'217 I-43M    TD - 3(24) 19 1  0 1   2 56000 10000      '/,
     $B(483)/'218 P-43N    TD - 4(24) 19 1  0 1   2 56666 10000      '/,
     $B(484)/'219 F-43C    TD - 5(24) 19 1  0 1   2 56666 10000      '/,
     $B(485)/'220 I-43D    TD - 6(24) 19 1  0 1   2 56339 10000      '/,
     $B(486)/'221 PM-3M    OH - 1(48) 20 0  0 1   3 33000 24000 10000'/,
     $B(487)/'222*PN-3N    OH - 2(48) 20 0  0 1   3 33666 24000 10000'/,
     $B(488)/'222+PN-3N    OH - 2(48) 20 0  0 1   3 33000 24060 10000'/,
     $B(489)/'223 PM-3N    OH - 3(48) 20 0  0 1   3 33000 24666 10000'/,
     $B(490)/'224*PN-3M    OH - 4(48) 20 0  0 1   3 33666 24666 10000'/,
     $B(491)/'224+PN-3M    OH - 4(48) 20 0  0 1   3 33000 24606 10000'/,
     $B(492)/'225 FM-3M    OH - 5(48) 20 0  0 1   3 33000 24000 10000'/,
     $B(493)/'226 FM-3C    OH - 6(48) 20 0  0 1   3 33000 24666 10000'/,
     $B(494)/'227*FD-3M    OH - 7(48) 20 0  0 1   3 33333 24333 10000'/,
     $B(495)/'227+FD-3M    OH - 7(48) 20 0  0 1   3 33000 24303 10000'/,
     $B(496)/'228*FD-3C    OH - 8(48) 20 0  0 1   3 33999 24333 10000'/,
     $B(497)/'228+FD-3C    OH - 8(48) 20 0  0 1   3 33000 24363 10000'/,
     $B(498)/'229 IM-3M    OH - 9(48) 20 0  0 1   3 33000 24000 10000'/,
     $B(499)/'230 IA-3D    OH -10(48) 20 0  0 1   3 33000 24339 10000'/,
c another choice of the unique axis (c) for P2_1/c group
     $B(500)/' 14 P112_1/A C2H- 5( 4) 35 0  0 6   2 33000 36606      '/,
     $B(501)/' 14 P112_1/N C2H- 5( 4) 35 0  0 6   2 33000 36666      '/,
     $B(502)/' 14 P112_1/B C2H- 5( 4) 35 0  0 6   2 33000 36066      '/
c
c  25.06.99 A. Perlov:
c  I've changed compleatly processing of group identification
c  as an input it will be character string, which can contain:
c  a) group number
c  b) group number+origin set  : 1227 - 227 gr 1 or. set
c  c) number in this table: 10487 - 487 entry
c  d) identification of group (should start from the first position)
c  e) identification of group + origin set: FD-3M:1 1 or. set
c   
c  If group can contain more than 1 entry it will return error code IERR
c  Normal end: IERR=1
c  IERR=0 - such group not found
c  IERR>1 - there are IERR appropriate choises       
c  IERR<0 - there is an ambiguity in the ORIGIN SET
c  If group is found b0 contains group identification (if IERR<>0) default
c  chois
c  DEFAULT CHOICE: origin set 2, last possible group in the table
c
c

      iprint=ierr
      IERR=0
      if(ichar(B0(1:1)).lt.ichar('A'))then
c
c  number:
c
        read(B0,*)IN

        ini=in
        B0='***************************************************'
        iorig=0
        aorig=' '
        if(in.gt.1000.and.in.lt.1231)then
          iorig=1
          aorig='*'
          in=in-1000
        else if(in.gt.2000.and.in.lt.2231)then
          iorig=2
          aorig='+'
          in=in-2000
        endif
        if(in.gt.0.and.in.lt.231)then
c
c   Group number defined
c
          IERR=0
          do ii=1,nspcgroups            !499
            read(b(ii)(1:4),'(i3,a1)')igr,aor
            if(igr.eq.in.and.(aor.eq.aorig.or.aorig.eq.' '))then
              b0=b(ii)
              b0(56:)=' '
              IERR=IERR+1
              if(iprint.eq.-100)then
                b0(14:)=' '                 
                if(aor.eq.'*')b0(lengths(b0)+1:)=':1'
                if(aor.eq.'+')b0(lengths(b0)+1:)=':2'
                print*,b0(1:3),'    ',b0(5:16)
                b0=b(ii)
              endif
            endif
          enddo
          read(b0,'(i3)')ini 
        else if(in.gt.10000.and.in.lt.10500)then
          IERR=1
          b0=b(in-10000)
          b0(56:)=' '
          read(b0,'(i3)')ini
        endif
      else
c
c  letter, assuming identification
c

        ini=-1
c
c  to upper case:
c
        do i=1,10
          ic=ichar(b0(i:i))
          if(ic.ge.97.and.ic.lt.122)b0(i:i)=char(ic-32) ! to upper case
        enddo

        aor=' '
        in=index(b0,':')-1
        if(in.lt.0)then
          in=index(b0,' ')
        else
          aor='+'
          read(b0(in+2:),'(i1)')iorg
          if(iorg.eq.1)aor='*'
        endif
        in=min(in,9)
        DO I=1,nspcgroups
          if(index(b(i),b0(1:in)).eq.5.and.
     $         ((iorg.eq.0.and.(b(i)(4:4).eq.' '.or.b(i)(4:4).eq.'+'))
     $         .or.(iorg.ne.0.and.b(i)(4:4).eq.aor)))then
            b0=b(i)
            b0(56:)=' '
            read(b0,'(i3)')ini
            IERR=1
            if(aor.ne.b0(4:4))IERR=-1
            return
          endif
        ENDDO
        if(iprint.eq.-100)then
          DO I=1,nspcgroups
            if(index(b(i),b0(1:in)).eq.14)then
              print*,b(i)(1:3),'    ',b(i)(5:19)
            endif
          ENDDO
        endif
      endif
      end
